-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Hôte : localhost:3306
-- Généré le : sam. 16 août 2025 à 10:24
-- Version du serveur : 10.11.13-MariaDB-cll-lve
-- Version de PHP : 8.4.10

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `dykqnvjf_gespes360`
--

DELIMITER $$
--
-- Procédures
--
CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `ActualiserRentabiliteBiensMensuelle` ()   BEGIN
  DECLARE mois_prec INT;
  DECLARE done INT DEFAULT FALSE;
  DECLARE id_bien_courant INT;
  DECLARE revenu DECIMAL(12,2);
  DECLARE depense DECIMAL(12,2);
  DECLARE benefice DECIMAL(12,2);
  DECLARE statut_nouveau VARCHAR(10);
  DECLARE biens_cursor CURSOR FOR 
    SELECT id_bien FROM biens;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
  SET mois_prec = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH));
  OPEN biens_cursor;
  read_loop: LOOP
    FETCH biens_cursor INTO id_bien_courant;
    IF done THEN
      LEAVE read_loop;
    END IF;
    SELECT montant_revenu INTO revenu
    FROM revenus_biens
    WHERE id_bien = id_bien_courant AND MONTH(date_enregistrement) = mois_prec
    LIMIT 1;
    SELECT montant_depense INTO depense
    FROM depenses_biens
    WHERE id_bien = id_bien_courant AND MONTH(date_enregistrement) = mois_prec
    LIMIT 1;
    SET benefice = COALESCE(revenu, 0) - COALESCE(depense, 0);
    IF benefice > 0 THEN
      SET statut_nouveau = 'actif';
      INSERT INTO gains (id_bien, montant_gain, date_gain)
      VALUES (id_bien_courant, benefice, CURDATE());
    ELSEIF benefice < 0 THEN
      SET statut_nouveau = 'passif';
      INSERT INTO pertes (id_bien, montant_perte, date_perte)
      VALUES (id_bien_courant, ABS(benefice), CURDATE());
    ELSE
      SET statut_nouveau = 'neutre';
    END IF;
UPDATE biens
SET benefice_produit = benefice,
    statut = statut_nouveau,
    date_mise_a_jour = NOW()
WHERE id_bien = id_bien_courant;
  END LOOP;
  CLOSE biens_cursor;
  SELECT 
    id_bien,
    mois_prec AS mois_reference,
    benefice_produit,
    statut
  FROM biens;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `AffecterFluxAutomatiquement` ()   BEGIN
  -- Affectation des revenus vers compte de type salaire
  UPDATE revenus R
  SET id_compte = (
    SELECT C.id_compte 
    FROM comptes C 
    WHERE C.id_utilisateur = R.id_receveur AND C.type_compte = 'salaire' AND C.statut = 'actif' LIMIT 1
  )
  WHERE R.id_compte IS NULL;
  -- Affectation des gains vers compte de type investissement ou courant
  UPDATE gains G
  SET id_compte = (
    SELECT C.id_compte 
    FROM comptes C 
    WHERE C.id_utilisateur = (
      SELECT B.id_utilisateur FROM biens B WHERE B.id_bien = G.id_bien
    ) AND C.type_compte IN ('investissement','courant') AND C.statut = 'actif' LIMIT 1
  )
  WHERE G.id_compte IS NULL;
  -- Affectation des épargnes vers compte de type épargne
  UPDATE epargner E
  SET id_compte = (
    SELECT C.id_compte 
    FROM comptes C 
    WHERE C.id_utilisateur = (
      SELECT EC.id_utilisateur FROM epargne_ct EC WHERE EC.id_epargne_ct = E.id_epargne_ct
    ) AND C.type_compte = 'épargne' AND C.statut = 'actif' LIMIT 1
  )
  WHERE id_compte IS NULL;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `AjouterConseilsParDefaut` (IN `id_utilisateur_cible` INT)   BEGIN
  INSERT INTO conseils (id_utilisateur, type_conseil, message_conseil, date_generation)
  VALUES
    (id_utilisateur_cible, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', NOW()),
    (id_utilisateur_cible, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', NOW()),
    (id_utilisateur_cible, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', NOW()),
    (id_utilisateur_cible, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', NOW()),
    (id_utilisateur_cible, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', NOW());
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `AttribuerPalierBudget` ()   BEGIN
  INSERT INTO coaching_budget_personnalise (
    id_utilisateur, date_suggestion, profil_detecte, message_conseil, action_recommandee, niveau_urgence
  )
  SELECT 
    SB.id_utilisateur,
    CURDATE(),
    PB.nom_palier,
    PB.message_pedagogique,
    CONCAT('Accédez à : ', PB.module_apprentissage, '. Débloqué : ', PB.acces_debloque),
    'modéré'
  FROM score_budget_patrimonial SB
  JOIN paliers_pedagogiques_budget PB ON
    CASE
      WHEN SB.score_global BETWEEN 0 AND 49 THEN PB.tranche_score = '0-49'
      WHEN SB.score_global BETWEEN 50 AND 74 THEN PB.tranche_score = '50-74'
      WHEN SB.score_global BETWEEN 75 AND 89 THEN PB.tranche_score = '75-89'
      WHEN SB.score_global >= 90 THEN PB.tranche_score = '90-100'
    END
  WHERE SB.mois = MONTH(CURDATE()) AND SB.annee = YEAR(CURDATE());
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `AuditerFinancementStrategique` ()   BEGIN
    INSERT INTO journal_financements (
        id_financer, source_fonds, cible, conformite, remarque
    )
    SELECT 
        F.id_financer,
        CASE 
            WHEN F.id_gain IS NOT NULL THEN 'gain'
            WHEN F.id_revenu IS NOT NULL THEN 'revenu'
            ELSE 'Inconnu'
        END,
        COALESCE(DP.type_depense, 'Non précisée'),
        CASE 
            WHEN F.id_gain IS NOT NULL AND (DP.id_bien IS NULL OR DP.id_bien = 0) THEN 'non conforme'
            ELSE 'valide'
        END,
        'Audit mensuel automatisé de conformité patrimoniale.'
    FROM financer F
    LEFT JOIN depenses DP ON F.id_depense = DP.id_depense
    WHERE MONTH(F.date_financer) = MONTH(CURDATE()) AND YEAR(F.date_financer) = YEAR(CURDATE());
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `DeduireActionsEpargne` ()   BEGIN
    INSERT INTO actions_patrimoniales_recommandees (
        id_epargne_ct, date_proposition, type_action, niveau_urgence, justification, instruction
    )
    SELECT 
        EC.id_epargne_ct,
        CURDATE(),
        'Réaffectation de fonds',
        'modérée',
        'Écart significatif détecté à moins de 7 jours de l’échéance.',
        'Réallouer 10% du solde du compte associé vers cette épargne.'
    FROM epargne_ct EC
    WHERE EC.statut = 'en_cours'
      AND EC.priorite = 'haute'
      AND DATEDIFF(EC.date_echeance, CURDATE()) <= 7
      AND ROUND((EC.solde_actuel / EC.montant_vise) * 100, 2) < 60.00;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `DetecterRevenusNonEncaisses` ()   BEGIN
  INSERT INTO alertes_revenus (
    id_revenu, date_alerte, niveau_gravite, message
  )
  SELECT 
    id_revenu,
    CURDATE(),
    'élevée',
    CONCAT('Revenu prévu non encaissé à date : ', source)
  FROM revenus
  WHERE statut = 'prévu' AND date_revenu < CURDATE();
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `DetecterSurchargeDepenses` (IN `seuil_mensuel` DECIMAL(12,2))   BEGIN
  INSERT INTO alertes_depenses (
    id_faiseur, date_alerte, type_alerte, gravite, message
  )
  SELECT 
    id_faiseur,
    CURDATE(),
    'Surcharge budgétaire',
    'élevée',
    CONCAT('Attention : total des dépenses mensuelles dépasse le seuil de ', seuil_mensuel, ' FCFA.')
  FROM depenses
  WHERE statut_depense = 'réalisée'
    AND MONTH(date_depense) = MONTH(CURDATE())
    AND YEAR(date_depense) = YEAR(CURDATE())
  GROUP BY id_faiseur
  HAVING SUM(montant) > seuil_mensuel;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `EvaluerSaturationDetteMensuelle` (IN `revenu_mensuel` DECIMAL(12,2))   BEGIN
    INSERT INTO alertes_dettes (
        id_dette, date_alerte, seuil_depasse, type_alerte, gravite, message
    )
    SELECT
        id_dette,
        CURDATE(),
        TRUE,
        'Saturation patrimoniale',
        'élevée',
        CONCAT('Versement mensuel estimé dépasse 35% du revenu. Simulation : ', ROUND((montant_simule / revenu_mensuel) * 100,2), '%.')
    FROM simulation_remboursement
    WHERE statut_simulation = 'prévision'
      AND ROUND((montant_simule / revenu_mensuel) * 100,2) > 35.00;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `GenererProfilComportementUtilisateur` ()   BEGIN
  INSERT INTO profil_comportement_utilisateur (
    id_utilisateur, mois, annee, nb_sessions, duree_totale_minutes, frequence_connexion, regularite, score_engagement, badge_comportement
  )
  SELECT 
    S.id_utilisateur,
    MONTH(CURDATE()), YEAR(CURDATE()),
    COUNT(*) AS nb_sessions,
    SUM(TIME_TO_SEC(S.duree_session)/60) AS duree_totale,
    CASE WHEN COUNT(*) >= 10 THEN 'fréquente'
         WHEN COUNT(*) >= 5 THEN 'modérée'
         ELSE 'rare' END AS fréquence,
    CASE WHEN COUNT(*) >= 3 AND COUNT(DISTINCT DATE(S.date_connexion)) >= 3 THEN 'exemplaire'
         WHEN COUNT(DISTINCT DATE(S.date_connexion)) >= 2 THEN 'stable'
         ELSE 'irrégulière' END AS regularite,
    0, -- score calculé plus tard
    NULL -- badge calculé plus tard
  FROM sessions S
  WHERE MONTH(S.date_connexion) = MONTH(CURDATE()) AND YEAR(S.date_connexion) = YEAR(CURDATE())
  GROUP BY S.id_utilisateur;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `GenererRecommandationsBudget` ()   BEGIN
  INSERT INTO coaching_budget_personnalise (
    id_utilisateur, date_suggestion, profil_detecte, message_conseil, action_recommandee, niveau_urgence
  )
  SELECT 
    SBP.id_utilisateur,
    CURDATE(),
    CONCAT('Score mensuel ', SBP.score_global),
    RSB.message,
    RSB.action_conseillee,
    RSB.niveau_priorite
  FROM score_budget_patrimonial SBP
  JOIN recommandations_score_budget RSB ON
    CASE
      WHEN SBP.score_global BETWEEN 0 AND 49 THEN RSB.tranche_score = '0-49'
      WHEN SBP.score_global BETWEEN 50 AND 74 THEN RSB.tranche_score = '50-74'
      WHEN SBP.score_global BETWEEN 75 AND 89 THEN RSB.tranche_score = '75-89'
      WHEN SBP.score_global >= 90 THEN RSB.tranche_score = '90-100'
    END
  WHERE MONTH(CURDATE()) = SBP.mois AND YEAR(CURDATE()) = SBP.annee;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `GenererSuggestionsCoaching` ()   BEGIN
  -- Exemple : dépenses > revenus
  INSERT INTO coaching_budget_personnalise (
    id_utilisateur, date_suggestion, profil_detecte, message_conseil, action_recommandee, niveau_urgence
  )
  SELECT 
    D.id_faiseur,
    CURDATE(),
    'Surconsommation mensuelle',
    'Vos dépenses ont dépassé vos revenus ce mois-ci.',
    'Réviser les postes budgétaires variables et renforcer l’épargne stratégique.',
    'critique'
  FROM depenses D
  JOIN revenus R ON R.id_receveur = D.id_faiseur
  WHERE MONTH(D.date_depense) = MONTH(CURDATE()) AND YEAR(D.date_depense) = YEAR(CURDATE())
    AND MONTH(R.date_revenu) = MONTH(CURDATE()) AND YEAR(R.date_revenu) = YEAR(CURDATE())
  GROUP BY D.id_faiseur
  HAVING SUM(D.montant) > SUM(R.montant);
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `InitialiserStructuresUtilisateur` (IN `nouvel_utilisateur` INT, IN `compte_principal` INT)   BEGIN
  -- Épargne atteinte (préremplie pour les biens acquis)
  INSERT INTO epargne_ct (
    id_utilisateur, id_compte, type_epargne, objectif,
    priorite, statut, taux_progression, montant_vise,
    montant_actuel, commentaire, date_echeance, date_enregistrement
  ) VALUES (
    nouvel_utilisateur, compte_principal, 'biens_existant', 'Épargne simulée pour bien acquis',
    'haute', 'atteint', 100, 0,
    0, 'Structure patrimoniale de démarrage', CURDATE(), NOW()
  );
  -- Dette clôturée (préremplie pour bien financé déjà remboursé)
  INSERT INTO dettes (
    id_contracteur, id_octroyeur, id_compte, montant_emprunt, taux_d_interest,
    type_dette, garantie, origine_dette, description,
    date_emprunt, date_remboursement, date_enregistrement,
    montant_remboursement, statut, niveau_priorite, historique_remboursements
  ) VALUES (
    nouvel_utilisateur, 1, 1, 0, 0.00,
    'ancienne_dette', 'non_specifiee', 'initialisation_systeme',
    'Dette simulée pour bien financé déjà existant',
    CURDATE(), CURDATE(), NOW(),
    0, 'remboursée', 'basse', 'aucun remboursement requis'
  );
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `RecommanderConseilEpargne` ()   BEGIN
  INSERT INTO alertes_epargne_ct (
    id_epargne_ct, date_alerte, type_alerte, niveau_priorite, message
  )
  SELECT 
    EC.id_epargne_ct,
    CURDATE(),
    'Recommandation automatique',
    CE.niveau_priorite,
    CE.texte_conseil
  FROM epargne_ct EC
  JOIN conseils_epargne CE ON 
    EC.priorite = CE.niveau_priorite
    AND DATEDIFF(EC.date_echeance, CURDATE()) <= CE.seuil_proximite
    AND ROUND((EC.solde_actuel / EC.montant_vise) * 100, 2) <= CE.seuil_progression
  WHERE EC.statut = 'en_cours' AND CE.actif = TRUE;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `SuggererDestinationRevenu` ()   BEGIN
  INSERT INTO suggestions_affectation_revenus (
    id_revenu, date_suggestion, destination_prioritaire, justification
  )
  SELECT 
    id_revenu,
    CURDATE(),
    'Épargne_CT',
    'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.'
  FROM revenus
  WHERE statut = 'encaissé';
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `ValiderCreationBien` (IN `id_utilisateur` INT, IN `montant_acquisition` DECIMAL(12,2), OUT `autorisation` TINYINT)   BEGIN
  DECLARE total_disponible DECIMAL(12,2);
  SELECT COALESCE(SUM(E.montant_actuel), 0) + COALESCE(SUM(D.montant_emprunt), 0)
  INTO total_disponible
  FROM epargner E
  LEFT JOIN dettes D ON D.id_emprunteur = id_utilisateur
  WHERE E.id_utilisateur = id_utilisateur AND D.statut = 'disponible';
  SET autorisation = (total_disponible >= montant_acquisition);
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `VerifierDepassementComptes` ()   BEGIN
  INSERT INTO alertes_comptes (
    id_compte, date_alerte, type_alerte, gravite, message
  )
  SELECT 
    id_compte,
    CURDATE(),
    'Dépassement de découvert autorisé',
    'élevée',
    CONCAT('Le solde du compte "', nom_compte, '" dépasse sa limite de découvert.')
  FROM comptes
  WHERE solde < -limite_decouvert;
END$$

CREATE DEFINER=`cpses_dysqeiuulf`@`localhost` PROCEDURE `Verifier_fond_financement_bien` (IN `id_epargne_ct` INT, IN `id_dette` INT, IN `montant_acquisition` DECIMAL(12,2), OUT `financable` TINYINT)   BEGIN
  DECLARE solde_epargne DECIMAL(12,2);
  DECLARE montant_dette DECIMAL(12,2);
  DECLARE total_fonds DECIMAL(12,2);
  -- Récupérer le solde de l’épargne sélectionnée
  SELECT COALESCE(E.montant_actuel, 0)
  INTO solde_epargne
  FROM epargne_ct E
  WHERE E.id_epargne_ct = id_epargne_ct;
  -- Récupérer le montant emprunté de la dette sélectionnée
  SELECT COALESCE(D.montant_emprunt, 0)
  INTO montant_dette
  FROM dettes D
  WHERE D.id_dette = id_dette;
  SET total_fonds = solde_epargne + montant_dette;
  -- Vérification de la solvabilité par rapport au coût du bien
  SET financable = (total_fonds >= montant_acquisition);
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `actions_patrimoniales_recommandees`
--

CREATE TABLE `actions_patrimoniales_recommandees` (
  `id_action` int(11) NOT NULL,
  `id_epargne_ct` int(11) DEFAULT NULL,
  `date_proposition` date DEFAULT NULL,
  `type_action` varchar(100) DEFAULT NULL,
  `niveau_urgence` enum('faible','modérée','urgente') DEFAULT NULL,
  `justification` text DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `statut` enum('proposée','appliquée','ignorée') DEFAULT 'proposée'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `alertes_comptes`
--

CREATE TABLE `alertes_comptes` (
  `id_alerte` int(11) NOT NULL,
  `id_compte` int(11) DEFAULT NULL,
  `date_alerte` date DEFAULT NULL,
  `type_alerte` varchar(100) DEFAULT NULL,
  `gravite` enum('faible','modérée','élevée') DEFAULT NULL,
  `message` text DEFAULT NULL,
  `resolu` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `alertes_comptes`
--

INSERT INTO `alertes_comptes` (`id_alerte`, `id_compte`, `date_alerte`, `type_alerte`, `gravite`, `message`, `resolu`) VALUES
(1, 4, '2025-08-05', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(2, 7, '2025-08-05', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(3, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(4, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(6, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(7, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(9, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(10, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(12, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(13, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(15, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(16, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(18, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(19, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0),
(21, 4, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte Afrikland First Bank Ndogpassi\" dépasse sa limite de découvert.', 0),
(22, 7, '2025-08-16', 'Dépassement de découvert autorisé', 'élevée', 'Le solde du compte \"Compte salaire CCA Bank Tsinga \" dépasse sa limite de découvert.', 0);

-- --------------------------------------------------------

--
-- Structure de la table `alertes_depenses`
--

CREATE TABLE `alertes_depenses` (
  `id_alerte` int(11) NOT NULL,
  `id_faiseur` int(11) DEFAULT NULL,
  `date_alerte` date DEFAULT NULL,
  `type_alerte` varchar(100) DEFAULT NULL,
  `gravite` enum('faible','modérée','élevée') DEFAULT NULL,
  `message` text DEFAULT NULL,
  `statut` enum('non traitée','résolue') DEFAULT 'non traitée'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `alertes_depots_epargne`
--

CREATE TABLE `alertes_depots_epargne` (
  `id_alerte` int(11) NOT NULL,
  `id_epargner` int(11) DEFAULT NULL,
  `id_epargne_ct` int(11) DEFAULT NULL,
  `date_alerte` date DEFAULT NULL,
  `message` text DEFAULT NULL,
  `niveau` enum('information','avertissement','violation') DEFAULT 'avertissement',
  `traitee` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `alertes_dettes`
--

CREATE TABLE `alertes_dettes` (
  `id_alerte_dette` int(11) NOT NULL,
  `id_dette` int(11) NOT NULL,
  `date_alerte` date NOT NULL,
  `seuil_depasse` tinyint(1) DEFAULT NULL,
  `type_alerte` varchar(100) DEFAULT NULL,
  `gravite` enum('faible','modérée','élevée') DEFAULT NULL,
  `message` text DEFAULT NULL,
  `statut_traitement` enum('non traité','résolu') DEFAULT 'non traité'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `alertes_epargne_ct`
--

CREATE TABLE `alertes_epargne_ct` (
  `id_alerte_ct` int(11) NOT NULL,
  `id_epargne_ct` int(11) NOT NULL,
  `date_alerte` date NOT NULL,
  `type_alerte` varchar(100) DEFAULT NULL,
  `niveau_priorite` enum('basse','moyenne','haute') DEFAULT NULL,
  `message` text DEFAULT NULL,
  `etat_traitement` enum('non traité','en cours','résolu') DEFAULT 'non traité'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `alertes_patrimoniales`
--

CREATE TABLE `alertes_patrimoniales` (
  `id_alerte` int(11) NOT NULL,
  `id_bien` int(11) NOT NULL,
  `date_alerte` date NOT NULL,
  `type_alerte` varchar(100) DEFAULT NULL,
  `niveau_gravite` enum('faible','modéré','élevé') DEFAULT NULL,
  `description` text DEFAULT NULL,
  `statut_traitement` enum('non traité','en cours','résolu') DEFAULT 'non traité'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `alertes_revenus`
--

CREATE TABLE `alertes_revenus` (
  `id_alerte` int(11) NOT NULL,
  `id_revenu` int(11) NOT NULL,
  `date_alerte` date NOT NULL,
  `niveau_gravite` enum('faible','moyenne','élevée') DEFAULT NULL,
  `message` text DEFAULT NULL,
  `statut_traitement` enum('non traité','résolu') DEFAULT 'non traité'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `biens`
--

CREATE TABLE `biens` (
  `id_bien` int(11) NOT NULL,
  `id_epargne_ct` int(11) DEFAULT NULL,
  `id_dette` int(11) DEFAULT NULL,
  `libelle_bien` varchar(255) DEFAULT NULL,
  `type_bien` enum('Résidence principale','Résidence secondaire','Terrain non bâti','Immeuble locatif','Local commercial','Bien en copropriété','Bien en construction','Véhicule personnel','Véhicule professionnel','Matériel informatique','Équipement professionnel','Mobilier résidentiel','Action cotée','Action non cotée','Obligation','Fonds d’investissement','Crypto-actif','Contrat d’assurance-vie','Part sociale','Fonds de commerce','Licence d’exploitation','Machine professionnelle','Stock valorisé','Franchise commerciale','Marque déposée','Logiciel développé','Droit d’auteur','Bien en indivision','Bien en démembrement','Bien hypothéqué','Bien acquis par donation','Bien bénéficiant d’un régime fiscal','Epoux/epouse') DEFAULT NULL,
  `description` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `source_financement` enum('Épargne','Dette','Épargne et dette','') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `responsable_gestion` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `frequence_utilisation` enum('Journalière','Hebdomadaire','Mensuelle','Trimestrielle','Semestrielle','Annuelle') DEFAULT 'Mensuelle',
  `montant_acquisition` decimal(12,2) DEFAULT NULL,
  `date_acquisition` date DEFAULT NULL,
  `valeur_actuelle` decimal(12,2) DEFAULT NULL,
  `taux_depreciation` decimal(5,2) DEFAULT NULL,
  `historique_valeurs` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `benefice_produit` decimal(12,2) DEFAULT 0.00,
  `statut` enum('actif','passif','non acquis','vendu','transmis','cédé','rétrocédé','non actif','neutre') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_enregistrement` datetime NOT NULL DEFAULT current_timestamp(),
  `date_mise_a_jour` datetime DEFAULT current_timestamp(),
  `categorie_bien` enum('immobilier','mobilier','financier','professionnel','incorporel','juridique','social','institutionnel') DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `biens`
--

INSERT INTO `biens` (`id_bien`, `id_epargne_ct`, `id_dette`, `libelle_bien`, `type_bien`, `description`, `source_financement`, `responsable_gestion`, `frequence_utilisation`, `montant_acquisition`, `date_acquisition`, `valeur_actuelle`, `taux_depreciation`, `historique_valeurs`, `benefice_produit`, `statut`, `date_enregistrement`, `date_mise_a_jour`, `categorie_bien`) VALUES
(1, 1, 5, 'Appartement bertoua', 'Immeuble locatif', 'Maison Bertoua ', 'Dette', 'Mme EYAMBE ', 'Mensuelle', 4000000.00, '2025-03-11', 5000000.00, 0.00, '', 0.00, 'neutre', '2025-07-20 00:00:00', '2025-08-16 09:50:59', 'immobilier'),
(2, 1, 5, 'Mariage (Madame et les enfants)', 'Epoux/epouse', 'Ras', 'Épargne et dette', 'Narcisse ', 'Mensuelle', 3500000.00, '2025-07-20', 0.00, -100.00, 'Deux donnés', 0.00, 'passif', '2025-07-20 00:00:00', '2025-07-20 08:39:31', 'incorporel'),
(3, 14, 2, 'InfinityTech SARL', 'Part sociale', '30% des parts d\'InfinityTech', 'Épargne', NULL, 'Mensuelle', 3000000.00, '2024-03-15', 9000000.00, 0.00, NULL, 0.00, 'actif', '2025-08-05 09:22:19', '2025-08-05 09:22:19', 'social'),
(4, 1, 2, 'Startuper Business Center SARL', 'Part sociale', '50% des parts de Startuper Business Center SARL', 'Épargne', '', 'Mensuelle', 500000.00, '2018-08-05', 0.00, 0.00, '', 0.00, 'non actif', '2025-08-05 09:27:09', '2025-08-12 07:18:18', 'social'),
(5, 1, 2, 'Salon de l\'Orientation et des Métiers', 'Droit d’auteur', 'Orientation conseil scolaire, académique et professionnelle', 'Épargne', 'Moi-même', 'Mensuelle', 0.00, '2016-02-23', 5000000.00, 0.00, NULL, 0.00, 'actif', '2025-08-05 10:55:25', '2025-08-05 10:55:25', 'incorporel'),
(6, 1, 2, 'Entreprise de restauration', 'Fonds de commerce', 'Entreprise de restauration', 'Épargne', 'Moi-même', 'Mensuelle', 0.00, '2025-08-05', 0.00, 0.00, NULL, 0.00, 'non actif', '2025-08-05 10:55:25', '2025-08-05 10:55:25', 'financier'),
(7, 1, 2, 'Entreprise vestimentaire', 'Fonds de commerce', 'Entreprise vestimentaire', 'Épargne', 'Moi-même', 'Mensuelle', 0.00, '2025-08-05', 0.00, 0.00, NULL, 0.00, 'non actif', '2025-08-05 10:59:12', '2025-08-05 10:59:12', 'incorporel'),
(8, 1, 2, 'Entreprise agroalimentaire et élevage', 'Fonds de commerce', 'Entreprise agroalimentaire et élevage', 'Épargne', 'Moi-même', 'Mensuelle', 0.00, '2025-08-05', 0.00, 0.00, NULL, 0.00, 'non actif', '2025-08-05 10:59:12', '2025-08-05 10:59:12', 'incorporel'),
(9, 1, 2, 'Entreprise immobilière', 'Immeuble locatif', 'Entreprise immobilière (achat et location terrains, maisons et meubles)', 'Épargne', 'Moi-même', 'Mensuelle', 0.00, '2025-08-05', 0.00, 0.00, NULL, 0.00, 'non actif', '2025-08-05 11:04:18', '2025-08-05 11:04:18', 'immobilier'),
(10, 1, 2, 'Société de crédit et financement', 'Fonds d’investissement', 'Société de crédit et financement pour faire des prêts, des financement de projets, placement de fond d\'investissement et autres actions financières telles que la crypto', 'Épargne', 'Moi-même', 'Mensuelle', 0.00, '2025-08-05', 0.00, 0.00, '', 0.00, 'actif', '2025-08-05 11:04:18', '2025-08-13 02:18:44', 'financier');

-- --------------------------------------------------------

--
-- Structure de la table `bilans_patrimoniaux`
--

CREATE TABLE `bilans_patrimoniaux` (
  `id_bilan` int(11) NOT NULL,
  `id_bien` int(11) NOT NULL,
  `date_bilan` date NOT NULL,
  `montant_produit` decimal(12,2) DEFAULT NULL,
  `total_gains` decimal(12,2) DEFAULT NULL,
  `total_pertes` decimal(12,2) DEFAULT NULL,
  `rendement_mensuel` decimal(5,2) DEFAULT NULL,
  `commentaire` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `coaching_budget_personnalise`
--

CREATE TABLE `coaching_budget_personnalise` (
  `id_coaching` int(11) NOT NULL,
  `id_utilisateur` int(11) DEFAULT NULL,
  `date_suggestion` date DEFAULT NULL,
  `profil_detecte` varchar(100) DEFAULT NULL,
  `message_conseil` text DEFAULT NULL,
  `action_recommandee` text DEFAULT NULL,
  `niveau_urgence` enum('faible','modéré','critique') DEFAULT NULL,
  `statut` enum('proposé','accepté','refusé','archivé') DEFAULT 'proposé'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `comptes`
--

CREATE TABLE `comptes` (
  `id_compte` int(11) NOT NULL,
  `id_utilisateur` int(11) DEFAULT NULL,
  `nom_compte` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `type_compte` enum('courant','épargne','investissement','salaire','caisse','poche') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `devise` enum('FCFA','EUR','DOLLAR américain','DOLLAR canadien') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `solde` decimal(12,2) DEFAULT NULL,
  `limite_decouvert` decimal(12,2) DEFAULT NULL,
  `taux_interet` decimal(5,2) DEFAULT NULL,
  `mode_ouverture` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_derniere_activite` datetime DEFAULT NULL,
  `statut` enum('actif','inactif') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_creation` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `comptes`
--

INSERT INTO `comptes` (`id_compte`, `id_utilisateur`, `nom_compte`, `type_compte`, `devise`, `solde`, `limite_decouvert`, `taux_interet`, `mode_ouverture`, `date_derniere_activite`, `statut`, `date_creation`) VALUES
(1, 1, 'Compte par défaut', 'investissement', 'FCFA', 0.00, 0.00, 0.00, 'Physique', '2025-06-26 02:06:04', 'actif', '2025-07-19 01:08:19'),
(2, 2, 'Compte UBA Bank Ange Raphaël', 'épargne', 'FCFA', 25000.00, 0.00, 0.00, 'Physique ', '2025-07-01 02:16:00', 'actif', '2025-07-19 01:20:36'),
(3, 2, 'Compte CCA Bank Bonamoussadi', 'épargne', 'FCFA', 4700000.00, 0.00, 0.00, 'Physique', '2025-07-01 02:16:47', 'actif', '2025-07-19 01:20:36'),
(4, 2, 'Compte Afrikland First Bank Ndogpassi', 'salaire', 'FCFA', -12000.00, 0.00, 0.00, 'Physique', '2020-07-01 02:20:38', 'inactif', '2025-07-19 01:24:56'),
(5, 2, 'Compte Orange Money 696794350', 'courant', 'FCFA', 6369.00, 500.00, 0.00, 'Électronique ', '2025-07-31 02:20:38', 'actif', '2025-07-19 01:24:56'),
(6, 2, 'Portefeuille porte monnaie', 'courant', 'FCFA', 2500.00, 5000000.00, 0.00, 'Physique ', '2025-07-19 02:28:00', 'actif', '2025-07-19 01:29:42'),
(7, 2, 'Compte salaire CCA Bank Tsinga ', 'salaire', 'FCFA', -145000.00, 136000.00, 0.00, 'Physique', '2025-06-26 02:06:04', 'actif', '2025-07-20 20:08:06'),
(8, 2, 'Caisse reunion famille paternelle Carine', 'épargne', 'FCFA', 10000.00, 50000.00, 0.00, 'Physique ', '2025-06-26 02:06:04', 'actif', '2025-08-04 07:55:37'),
(9, 2, 'Caisse réunion maman MOTH', 'épargne', 'FCFA', 25000.00, 300000.00, 0.00, 'Physique', '2025-07-01 02:16:47', 'actif', '2025-08-04 07:55:37'),
(10, 2, 'Caisse à domicile', 'épargne', 'FCFA', 0.00, 0.00, 0.00, 'Physique', '2025-08-05 08:05:43', 'actif', '2025-08-05 07:06:53');

-- --------------------------------------------------------

--
-- Structure de la table `conseils`
--

CREATE TABLE `conseils` (
  `id_conseil` int(11) NOT NULL,
  `id_utilisateur` int(11) DEFAULT NULL,
  `type_conseil` varchar(50) DEFAULT NULL,
  `message_conseil` longtext DEFAULT NULL,
  `date_generation` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `conseils`
--

INSERT INTO `conseils` (`id_conseil`, `id_utilisateur`, `type_conseil`, `message_conseil`, `date_generation`) VALUES
(82, 2, 'stratégique', 'Interdiction de financer une dépense personnelle par une épargne à court terme. Cette épargne est exclusivement réservée à l’acquisition de biens.', '2025-07-20 00:00:00'),
(83, 2, 'stratégique', 'Interdiction de financer une dépense personnelle par une dette. Toute dette contractée doit viser un bien patrimonial ou un levier productif.', '2025-07-20 00:00:00'),
(84, 2, 'stratégique', 'Plafond de dépenses personnelles : une dépense ne peut excéder 70% du revenu disponible mensuel.', '2025-07-20 00:00:00'),
(85, 2, 'stratégique', 'Plafond d’épargne : ne pas affecter plus de 30% du revenu vers l’épargne court terme sans justification stratégique.', '2025-07-20 00:00:00'),
(86, 2, 'coaching', 'Votre discipline budgétaire est fragile ce mois-ci. Réduisez les dépenses variables et optimisez votre épargne stratégique.', '2025-07-20 00:00:00'),
(87, 2, 'coaching', 'Augmentez vos apports vers l’épargne dédiée à l’acquisition de biens. Performance budgétaire moyenne détectée.', '2025-07-20 00:00:00'),
(88, 2, 'coaching', 'Très bonne maîtrise budgétaire ! Envisagez d’investir dans un actif stratégique ou d’optimiser vos gains.', '2025-07-20 00:00:00'),
(89, 2, 'coaching', 'Discipline exemplaire : vous pouvez servir de profil mentor et accéder aux modules avancés.', '2025-07-20 00:00:00'),
(90, 2, 'stratégique', 'Un gain ne peut financer une dépense non rattachée à un bien. Toute affectation doit servir un objectif patrimonial clair.', '2025-07-20 00:00:00'),
(91, 2, 'stratégique', 'Les financements doivent toujours être traçables et conformes au type de dépense ciblée.', '2025-07-20 00:00:00'),
(92, 2, 'comportemental', 'Votre engagement comportemental est faible ce mois-ci. Augmentez la régularité de vos connexions pour bénéficier pleinement des recommandations.', '2025-07-20 00:00:00'),
(93, 2, 'comportemental', 'Engagement exemplaire détecté. Vous accédez aux badges de présence et aux modules premium.', '2025-07-20 00:00:00'),
(94, 2, 'pédagogique', 'Palier : Novice patrimonial. Commencez par les fondamentaux de la discipline budgétaire.', '2025-07-20 00:00:00'),
(95, 2, 'pédagogique', 'Palier : Discipline naissante. Apprenez à maîtriser vos dépenses et renforcer l’épargne.', '2025-07-20 00:00:00'),
(96, 2, 'pédagogique', 'Palier : Patrimonial confirmé. Vous pouvez maintenant affiner vos stratégies d’investissement.', '2025-07-20 00:00:00'),
(97, 2, 'pédagogique', 'Palier : Maître stratégique. Vous maîtrisez l’équilibre budgétaire. Valorisez votre profil et devenez mentor.', '2025-07-20 00:00:00'),
(98, 2, 'règle de validation', 'Un bien ne peut être enregistré que si la somme des épargnes et/ou des dettes disponibles au moment de sa création est supérieure ou égale au montant d\'acquisition.', '2025-07-20 03:56:33'),
(99, 2, 'règle de suivi', 'Le bénéfice généré par un bien est la différence entre ses revenus et ses dépenses. Si ce bénéfice est négatif, une perte est automatiquement enregistrée ; si positif, un gain est automatiquement enregistré.', '2025-07-20 03:56:33'),
(100, 2, 'principe fondamental', 'L\'épargne n’est destinée qu’à financer l’acquisition de biens. Elle ne doit en aucun cas être utilisée pour des dépenses personnelles, courantes ou ponctuelles.', NULL),
(101, 2, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-07-20 15:11:12'),
(102, 2, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-07-20 15:11:12'),
(103, 2, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-07-20 15:11:12'),
(104, 2, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-07-20 15:11:12'),
(105, 2, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-07-20 15:11:12'),
(136, 2, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-07-20 16:41:43'),
(137, 2, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-07-20 16:41:43'),
(138, 2, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-07-20 16:41:43'),
(139, 2, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-07-20 16:41:43'),
(140, 2, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-07-20 16:41:43'),
(141, 2, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-07-20 16:55:24'),
(142, 2, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-07-20 16:55:24'),
(143, 2, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-07-20 16:55:24'),
(144, 2, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-07-20 16:55:24'),
(145, 2, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-07-20 16:55:24'),
(146, 2, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-08-05 19:09:23'),
(147, 2, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-08-05 19:09:23'),
(148, 2, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-08-05 19:09:23'),
(149, 2, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-08-05 19:09:23'),
(150, 2, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-08-05 19:09:23'),
(176, 27, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-08-14 13:49:11'),
(177, 27, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-08-14 13:49:11'),
(178, 27, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-08-14 13:49:11'),
(179, 27, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-08-14 13:49:11'),
(180, 27, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-08-14 13:49:11'),
(181, 28, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-08-14 14:07:30'),
(182, 28, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-08-14 14:07:30'),
(183, 28, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-08-14 14:07:30'),
(184, 28, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-08-14 14:07:30'),
(185, 28, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-08-14 14:07:30'),
(186, 29, 'init', 'Ajoutez vos biens patrimoniaux pour activer le suivi.', '2025-08-14 15:03:58'),
(187, 29, 'init', 'Fixez vos objectifs de stabilité ou de croissance financière.', '2025-08-14 15:03:58'),
(188, 29, 'init', 'Paramétrez vos fréquences d’utilisation pour recevoir des recommandations adaptées.', '2025-08-14 15:03:58'),
(189, 29, 'init', 'Consultez votre tableau de bord pour suivre vos gains, pertes et statuts.', '2025-08-14 15:03:58'),
(190, 29, 'init', 'Explorez les biens sous-performants pour les optimiser ou les réévaluer.', '2025-08-14 15:03:58');

-- --------------------------------------------------------

--
-- Structure de la table `conseils_epargne`
--

CREATE TABLE `conseils_epargne` (
  `id_conseil_ct` int(11) NOT NULL,
  `niveau_priorite` enum('haute','moyenne','basse') DEFAULT NULL,
  `seuil_proximite` int(11) DEFAULT NULL,
  `seuil_progression` decimal(5,2) DEFAULT NULL,
  `texte_conseil` text DEFAULT NULL,
  `actif` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `conseils_epargne`
--

INSERT INTO `conseils_epargne` (`id_conseil_ct`, `niveau_priorite`, `seuil_proximite`, `seuil_progression`, `texte_conseil`, `actif`) VALUES
(1, 'haute', 7, 50.00, 'Réduisez vos dépenses non essentielles pour renforcer votre épargne.', 1),
(2, 'haute', 3, 30.00, 'Activez un soutien extérieur ou reconsidérez le montant visé.', 1),
(3, 'moyenne', 10, 60.00, 'Planifiez des versements hebdomadaires ciblés pour rattraper le retard.', 1),
(4, 'basse', 15, 70.00, 'Suivi recommandé : ajustement progressif suffisant.', 1);

-- --------------------------------------------------------

--
-- Structure de la table `depenses`
--

CREATE TABLE `depenses` (
  `id_depense` int(11) NOT NULL,
  `id_faiseur` int(11) DEFAULT NULL,
  `id_receveur` int(11) DEFAULT NULL,
  `libelles_depenses` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `categories` enum('Vie_courante_et_besoins_essentiels','Activite_professionnelle_ou_business','Engagements_financiers','Depenses_sociales_ou_personnelles','Projets_et_investissements','Institutionnel_et_reglementaire') DEFAULT NULL,
  `sous_categories` enum('Logement','Alimentation','Transport','Santé','Éducation','Fournitures pro','Communication','Déplacement pro','Salaires','Remboursement dette','Versement épargne','Assurance','Loisirs','Cadeaux','Cérémonie','Habits','Immobilier','Inversement','Maintenance','Impôt taxes','Frais administratifs','Cotisation','Energie électrique','Autre 2','Autre 3','Autre 4','Autre 5','Autre 6','Autre 7','Autre 8','Autre 9') DEFAULT NULL,
  `type_depense` enum('Fixe','Variable') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `periodicite` enum('Journalière','Hebdomadaire','Mensuelle','Trimestrielle','Semestrielle','Annuelle','Alternative') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `mode_paiement` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `montant_periodique` decimal(12,2) DEFAULT NULL,
  `montant_annuel_estimatif` decimal(25,0) DEFAULT NULL,
  `statut_depense` enum('Prévue','Réalisée') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_echeance` date DEFAULT NULL,
  `description` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `piece_justificative` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `impact_budgetaire` enum('Faible','Moyen','Fort','') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `responsable_validation` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_prevu_depense` date DEFAULT NULL,
  `date_enregistrement` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `depenses`
--

INSERT INTO `depenses` (`id_depense`, `id_faiseur`, `id_receveur`, `libelles_depenses`, `categories`, `sous_categories`, `type_depense`, `periodicite`, `mode_paiement`, `montant_periodique`, `montant_annuel_estimatif`, `statut_depense`, `date_echeance`, `description`, `piece_justificative`, `impact_budgetaire`, `responsable_validation`, `date_prevu_depense`, `date_enregistrement`) VALUES
(1, 2, 1, 'Loyer', 'Vie_courante_et_besoins_essentiels', 'Logement', 'Fixe', 'Mensuelle', 'Dépôt Orange Money', 55000.00, 660000, 'Prévue', '2025-07-27', 'Loyer', 'Listing transaction', 'Fort', 'Moi-même ', '2025-06-27', '2025-07-18 00:00:00'),
(2, 1, 1, 'Facture d\'eau', 'Vie_courante_et_besoins_essentiels', 'Alimentation', 'Variable', 'Mensuelle', 'Dépôt Orange Money ', 5000.00, 60000, 'Prévue', '2025-07-20', 'Facture d\'eau ', 'listing orange money', 'Faible', 'moi-même ', '2025-06-27', '2025-07-18 00:00:00'),
(3, 2, 1, 'Facture électricité', 'Vie_courante_et_besoins_essentiels', 'Energie électrique', 'Variable', 'Mensuelle', 'Dépôt Orange Money ', 2600.00, 60000, 'Prévue', '2025-07-20', 'Paiement facture électricité', 'Listing dépôt Orange Money ', 'Faible', 'Moi-même ', '2025-07-20', '2025-07-20 00:00:00'),
(4, 2, 1, 'Petit déjeuner', 'Vie_courante_et_besoins_essentiels', 'Alimentation', 'Variable', 'Mensuelle', 'Cash', 1100.00, 190000, 'Réalisée', '2025-07-21', 'Ras', 'Ras', 'Faible', 'Moi-même ', '2025-07-21', '2025-07-21 00:00:00'),
(5, 2, 1, 'Aide famille élargie', 'Depenses_sociales_ou_personnelles', 'Cérémonie', 'Variable', 'Alternative', 'Dépôt Orange Money ', 25000.00, 500000, 'Prévue', '2025-07-20', '10000 Caisse tata René \r\n10000 en main à Ange Gracias \r\n5000 à maman Régine pour donner à maman Lydie', 'Listing transaction orange ', 'Moyen', 'Moi-même ', '2025-07-20', '2025-08-04 00:00:00'),
(6, 2, 1, 'Remboursement dette MINESEC long terme', 'Institutionnel_et_reglementaire', 'Remboursement dette', 'Fixe', 'Mensuelle', 'Virement bancaire', 134283.00, 1611396, 'Prévue', '2025-07-24', 'Paiement dette MINESEC ', 'Listing CCA Bank Online ', 'Fort', 'Moi-même ', '2025-07-24', '2025-08-04 00:00:00'),
(7, 2, 1, 'Détente, recréation, ressourcement personnelle seul ', 'Vie_courante_et_besoins_essentiels', 'Loisirs', 'Variable', 'Alternative', 'Cash', 50000.00, 600000, 'Prévue', '2025-08-27', 'RAS', 'Factures', 'Moyen', 'Moi-même', '2025-07-27', '2025-08-05 08:15:54'),
(8, 2, 1, 'Soutien mon épouse', 'Depenses_sociales_ou_personnelles', 'Autre 2', 'Variable', 'Alternative', 'Cash - Dépôt Orange Money', 100000.00, 1000000, 'Prévue', '2025-12-31', NULL, NULL, 'Fort', 'Moi-même', '2025-07-26', '2025-08-05 08:43:06'),
(9, 2, 1, 'Médicament maison (Madame, moi et les enfants)', 'Vie_courante_et_besoins_essentiels', 'Santé', 'Variable', 'Alternative', 'Cash', 15000.00, 250000, 'Prévue', '2025-12-31', NULL, NULL, 'Moyen', NULL, '2025-07-27', '2025-08-05 08:45:13'),
(10, 2, 1, 'Ratio de la maison', 'Vie_courante_et_besoins_essentiels', 'Alimentation', 'Fixe', 'Journalière', 'Cash - Dépôt Orange Money', 5000.00, 912500, 'Prévue', '2025-12-31', NULL, NULL, 'Fort', NULL, '2025-07-01', '2025-08-05 08:47:34'),
(11, 2, 1, 'Vêtements et entretien', 'Vie_courante_et_besoins_essentiels', 'Habits', 'Variable', 'Mensuelle', 'Cash - Dépôt Orange Money', 15000.00, 210000, 'Prévue', '2025-12-31', NULL, NULL, 'Moyen', NULL, '2025-07-27', '2025-08-05 08:50:54'),
(12, 2, 1, 'Connexion internet', 'Vie_courante_et_besoins_essentiels', 'Communication', 'Variable', 'Journalière', 'Cash - Dépôt Orange Money', 1000.00, 365000, 'Prévue', '2025-12-31', NULL, NULL, 'Faible', NULL, '2025-07-01', '2025-08-05 08:58:23'),
(13, 2, 1, 'Crédit de communication', 'Vie_courante_et_besoins_essentiels', 'Communication', 'Variable', 'Journalière', 'Cash - Dépôt Orange Money', 1000.00, 365000, 'Prévue', '2025-12-31', NULL, NULL, 'Faible', NULL, '2025-07-01', '2025-08-05 09:00:19'),
(14, 2, 1, 'Transport', 'Vie_courante_et_besoins_essentiels', 'Transport', 'Variable', 'Journalière', 'Cash - Dépôt Orange Money', 2000.00, 720000, 'Prévue', '2025-12-31', NULL, NULL, 'Moyen', NULL, '2025-07-01', '2025-08-05 09:04:10'),
(15, 2, 1, 'École des enfants', 'Vie_courante_et_besoins_essentiels', 'Éducation', 'Variable', 'Trimestrielle', 'Cash - Dépôt Bancaire', 200000.00, 1200000, 'Prévue', '2025-12-31', NULL, NULL, 'Fort', NULL, '2025-08-15', '2025-08-05 09:09:10'),
(16, 2, 1, 'Entretien de la maison', 'Vie_courante_et_besoins_essentiels', 'Immobilier', 'Variable', 'Mensuelle', 'Cash - Dépôt Orange Money', 15000.00, 180000, 'Prévue', '2025-12-31', NULL, NULL, 'Faible', NULL, '2025-07-27', '2025-08-05 09:10:58'),
(17, 2, 1, 'Aide amis(es) et connaissances', 'Vie_courante_et_besoins_essentiels', 'Autre 2', 'Variable', 'Mensuelle', 'Cash - Dépôt Orange Money', 25000.00, 300000, 'Prévue', '2025-12-31', NULL, NULL, 'Moyen', NULL, '2025-07-01', '2025-08-05 09:13:50'),
(18, 2, 1, 'Dépenses relatifs aux prestations personnelles', 'Activite_professionnelle_ou_business', 'Déplacement pro', 'Variable', 'Alternative', 'Cash - Dépôt Orange Money - Virement bancaire', 5000.00, 1825000, 'Prévue', '2025-12-31', NULL, NULL, 'Fort', NULL, '2025-07-01', '2025-08-05 18:25:25'),
(19, 2, 1, 'Dépenses relatives aux procédures administratives.', 'Institutionnel_et_reglementaire', 'Frais administratifs', 'Variable', 'Alternative', 'Cash - Dépôt Orange Money - Virement bancaire', 5000.00, 1825000, 'Prévue', '2025-12-31', NULL, NULL, 'Fort', NULL, '2025-08-05', '2025-08-05 18:35:22'),
(20, 2, 1, 'Facture d\'images radio et TV', 'Vie_courante_et_besoins_essentiels', 'Communication', 'Fixe', 'Trimestrielle', 'Cash - Dépôt Orange Money', 6000.00, 72000, 'Prévue', '2025-12-31', NULL, NULL, 'Faible', NULL, '2025-07-27', '2025-08-05 18:38:04');

-- --------------------------------------------------------

--
-- Structure de la table `depenses_biens`
--

CREATE TABLE `depenses_biens` (
  `id_depenses_biens` int(11) NOT NULL,
  `id_bien` int(11) DEFAULT NULL,
  `montant_depense` decimal(12,2) DEFAULT NULL,
  `motif_depense_bien` longtext CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `frequence_depense` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `motif_depense` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `piece_justificative` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `mois_depense` enum('Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `annee_depense` varchar(55) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_enregistrement` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `dettes`
--

CREATE TABLE `dettes` (
  `id_dette` int(11) NOT NULL,
  `id_contracteur` int(11) DEFAULT NULL,
  `id_octroyeur` int(11) DEFAULT NULL,
  `id_compte` int(11) NOT NULL,
  `libelle_dette` varchar(255) DEFAULT NULL,
  `montant_emprunt` decimal(12,2) DEFAULT NULL,
  `taux_d_interest` decimal(5,2) DEFAULT NULL,
  `montant_remboursement` decimal(12,2) DEFAULT NULL,
  `description` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `type_dette` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `origine_dette` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `garantie` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `statut` enum('active','remboursée','annulée') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `niveau_priorite` enum('haute','moyenne','basse') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_emprunt` date DEFAULT NULL,
  `date_remboursement` date DEFAULT NULL,
  `historique_remboursements` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_enregistrement` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `dettes`
--

INSERT INTO `dettes` (`id_dette`, `id_contracteur`, `id_octroyeur`, `id_compte`, `libelle_dette`, `montant_emprunt`, `taux_d_interest`, `montant_remboursement`, `description`, `type_dette`, `origine_dette`, `garantie`, `statut`, `niveau_priorite`, `date_emprunt`, `date_remboursement`, `historique_remboursements`, `date_enregistrement`) VALUES
(2, 2, 1, 2, 'Dette nulle', 0.00, 0.00, 0.00, 'Dette simulée pour bien financé déjà existant', 'ancienne_dette', 'initialisation_systeme', 'non_specifiee', 'remboursée', 'basse', '2025-07-20', '2025-07-20', 'aucun remboursement requis', '2025-07-20 00:00:00'),
(5, 2, 1, 7, 'Dette prêt bancaire MINESEC', 7500000.00, 38.79, 19336752.00, 'RAS', 'Prêt bancaire', 'MINESEC/MINFOP/MINFI', 'Assurance', 'active', 'haute', '2023-08-01', '2036-08-15', '14 mois déjà remboursés sur 144', '2025-08-05 00:14:31'),
(6, 2, 1, 6, 'Dette YARRO financement test de langue anglais IELT et équivalence de diplôme', 750000.00, 0.00, 750000.00, '1', '', 'Projet de voyage', 'Système de confiance', 'active', 'haute', '2025-06-01', '2025-10-31', '1', '2025-08-05 11:17:47'),
(7, 2, 1, 6, 'Dette équivalence de diplôme et autres documents', 450000.00, 0.00, 450000.00, '1', '', 'Projet de voyage', 'Système de confiance', 'active', 'haute', '2025-05-01', '2025-10-31', '1', '2025-08-05 11:17:47'),
(8, 2, 1, 6, 'Dette monsieur NYA', 80000.00, 22.00, 100000.00, '1', 'Dette entreprise (bien InfinityTech SARL)', 'Problème SOM2025', 'Système de confiance', 'active', 'haute', '2025-02-02', '2025-08-31', '1', '2025-08-05 11:23:32'),
(9, 2, 1, 6, 'Dette maman Anna sec LYBIBO', 500000.00, 0.00, 600000.00, NULL, 'Dette entreprise (bien InfinityTech SARL)', 'Problème InfinityTech SARL', 'Système de confiance', 'active', 'haute', '2024-09-30', '2025-08-31', NULL, '2025-08-05 11:23:32'),
(10, 2, 1, 6, 'Dette Mr Ali', 350000.00, 22.00, 600000.00, NULL, 'Dette entreprise (bien InfinityTech SARL)', 'Financement marché ITSARL', 'Système de confiance', 'active', 'haute', '2024-11-01', '2025-08-31', NULL, '2025-08-05 11:33:16'),
(11, 2, 1, 6, 'Dette réunion maman MOTH', 400000.00, 10.00, 440000.00, NULL, NULL, NULL, 'Système de confiance. Madame est membre de la réunion', 'active', 'haute', '2025-05-01', '2025-08-31', '190000 FCFA déjà remboursée', '2025-08-05 11:39:03'),
(12, 2, 1, 6, 'Prime et salaire concours des orateurs et SOM2025', 350000.00, 0.00, 350000.00, NULL, NULL, NULL, NULL, 'active', 'haute', '2025-02-01', '2025-10-31', NULL, '2025-08-05 11:40:43'),
(13, 2, 1, 6, 'Dette Censeur ENONGA', 45000.00, 20.00, 65000.00, NULL, NULL, NULL, NULL, 'active', 'haute', '2025-02-01', '2025-08-31', NULL, '2025-08-05 11:46:31'),
(14, 2, 1, 6, 'Dette Dr GAUTIER Complexe de la professionnalisation', 60000.00, 0.00, 100000.00, NULL, NULL, NULL, NULL, 'active', 'basse', '2025-02-01', '2025-08-31', NULL, '2025-08-05 11:46:31'),
(17, 2, 1, 6, 'Dette maman Muna', 250000.00, 0.00, 250000.00, NULL, NULL, NULL, NULL, 'active', 'basse', '2025-02-01', '2025-09-30', NULL, '2025-08-05 11:49:23'),
(18, 2, 1, 6, 'Dette Fabien', 100000.00, 0.00, 150000.00, NULL, NULL, NULL, NULL, 'active', 'basse', '2024-09-30', '2025-09-30', NULL, '2025-08-05 11:49:23'),
(19, 2, 1, 6, 'Dette business mutation', 1200000.00, 0.00, 1200000.00, NULL, NULL, NULL, NULL, 'active', 'basse', '2023-09-01', '2025-09-30', NULL, '2025-08-05 11:50:49'),
(29, 27, NULL, 1, NULL, 0.00, 0.00, 0.00, 'Dette simulée pour bien financé déjà existant', 'ancienne_dette', 'initialisation_systeme', 'non_specifiee', 'remboursée', 'basse', '2025-08-14', '2025-08-14', 'aucun remboursement requis', '2025-08-14 13:49:11'),
(30, 28, NULL, 1, NULL, 0.00, 0.00, 0.00, 'Dette simulée pour bien financé déjà existant', 'ancienne_dette', 'initialisation_systeme', 'non_specifiee', 'remboursée', 'basse', '2025-08-14', '2025-08-14', 'aucun remboursement requis', '2025-08-14 14:07:30'),
(31, 29, NULL, 1, NULL, 0.00, 0.00, 0.00, 'Dette simulée pour bien financé déjà existant', 'ancienne_dette', 'initialisation_systeme', 'non_specifiee', 'remboursée', 'basse', '2025-08-14', '2025-08-14', 'aucun remboursement requis', '2025-08-14 15:03:58');

-- --------------------------------------------------------

--
-- Structure de la table `epargner`
--

CREATE TABLE `epargner` (
  `id_epargner` int(11) NOT NULL,
  `id_epargne_ct` int(11) NOT NULL,
  `id_gain` int(11) DEFAULT NULL,
  `id_revenu` int(11) DEFAULT NULL,
  `libelle_epargner` varchar(255) DEFAULT NULL,
  `montant` decimal(12,2) DEFAULT NULL,
  `date_epargne` date DEFAULT NULL,
  `heure_epargne` time DEFAULT NULL,
  `origine_fonds` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `moyen_transfer` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `justificatif_depot` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `responsable_enregistrement` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `note_strategique` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déclencheurs `epargner`
--
DELIMITER $$
CREATE TRIGGER `MajSoldeEpargneCT` AFTER INSERT ON `epargner` FOR EACH ROW BEGIN
    UPDATE epargne_ct
    SET montant_actuel = montant_actuel + NEW.montant
    WHERE id_epargne_ct = NEW.id_epargne_ct;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `Trg_Epargner_Deduction` AFTER INSERT ON `epargner` FOR EACH ROW BEGIN

  DECLARE montant_cible DECIMAL(12,2);

  DECLARE solde_gain DECIMAL(12,2);

  DECLARE solde_revenu DECIMAL(12,2);

  DECLARE reste DECIMAL(12,2);

  SET montant_cible = NEW.montant;

  -- Étape 1 : déduction sur le gain

  IF NEW.id_gain IS NOT NULL THEN

    SELECT montant_gain INTO solde_gain FROM gains WHERE id_gain = NEW.id_gain;

    IF solde_gain >= montant_cible THEN

      UPDATE gains SET montant_gain = montant_gain - montant_cible WHERE id_gain = NEW.id_gain;

    ELSE

      SET reste = montant_cible - solde_gain;

      UPDATE gains SET montant_gain = 0 WHERE id_gain = NEW.id_gain;

      -- Étape 2 : complément sur le revenu

      IF NEW.id_revenu IS NOT NULL THEN

        SELECT montant INTO solde_revenu FROM revenus WHERE id_revenu = NEW.id_revenu;

        IF solde_revenu >= reste THEN

          UPDATE revenus SET montant = montant - reste WHERE id_revenu = NEW.id_revenu;

        ELSE

          SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Solde insuffisant sur gain et revenu pour couvrir l’épargne';

        END IF;

      ELSE

        SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Gain insuffisant et aucun revenu indiqué';

      END IF;

    END IF;

  -- Si aucun gain n’est indiqué, on passe directement au revenu

  ELSEIF NEW.id_revenu IS NOT NULL THEN

    SELECT montant INTO solde_revenu FROM revenus WHERE id_revenu = NEW.id_revenu;

    IF solde_revenu >= montant_cible THEN

      UPDATE revenus SET montant = montant - montant_cible WHERE id_revenu = NEW.id_revenu;

    ELSE

      SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Solde revenu insuffisant pour couvrir l’épargne';

    END IF;

  ELSE

    SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'Aucune source (gain ou revenu) précisée pour épargner';

  END IF;

END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `epargne_ct`
--

CREATE TABLE `epargne_ct` (
  `id_epargne_ct` int(11) NOT NULL,
  `id_utilisateur` int(11) NOT NULL,
  `id_compte` int(11) NOT NULL,
  `libelle_epargne` text DEFAULT NULL,
  `type_epargne` enum('Épargne structurelle','Constitution capitale','Fonds d''urgence','Stabilisation budgetaire','Épargne projetée','Objectif achat','Objectif etudes','Objectif evenement','Épargne stratégique','Investissement financier','Plan retraite','Optimisation fiscale','Épargne comportementale','Challenge personnel','Auto recompense','Coffre silencieux','Épargne institutionnelle','Plan epargne employeur','Plan epargne associe','Epargne mutualisée','Épargne technique ou simulée','Epargne virtuel','Epargne atteinte','Autre 1','Autre 2','Autre 3','Autre 4','Autre 5','Autre 6','Autre 7','Aucun','biens_existant') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `objectif` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `priorite` enum('haute','moyenne','basse') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `statut` enum('en_cours','atteint','reporté') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `taux_progression` decimal(5,2) DEFAULT NULL,
  `montant_vise` decimal(12,2) DEFAULT NULL,
  `montant_actuel` decimal(12,2) DEFAULT NULL,
  `commentaire` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_echeance` date DEFAULT NULL,
  `date_enregistrement` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `epargne_ct`
--

INSERT INTO `epargne_ct` (`id_epargne_ct`, `id_utilisateur`, `id_compte`, `libelle_epargne`, `type_epargne`, `objectif`, `priorite`, `statut`, `taux_progression`, `montant_vise`, `montant_actuel`, `commentaire`, `date_echeance`, `date_enregistrement`) VALUES
(1, 2, 2, 'Epargne nulle', 'biens_existant', 'Pour justifier les biens actuels', 'haute', 'atteint', 100.00, 1.00, 1.00, 'RAS', '2025-07-20', '2025-07-20 00:00:00'),
(6, 2, 8, 'Epargne réunion famille paternelle Carine', 'Épargne projetée', 'Renforcer les moyens pour le projet voyage Canada.', 'moyenne', 'en_cours', 60.83, 120000.00, 73000.00, '', '2025-12-31', '2025-08-04 00:00:00'),
(7, 2, 9, 'Epargne réunion maman MOTH', 'Épargne projetée', 'Renforcer les moyens pour le projet voyage Canada.', 'moyenne', 'en_cours', 125.00, 300000.00, 375000.00, 'ezse', '2025-12-31', '2025-08-04 00:00:00'),
(14, 2, 5, 'Coffre fort Orange Money', 'Épargne structurelle', 'Épargne projet voyage Canada ', 'basse', 'en_cours', 50.00, 200000.00, 100000.00, NULL, '2025-12-05', '2025-08-05 08:05:28'),
(15, 2, 3, 'Caisse épargne compte CCA', 'Épargne structurelle', 'Projet voyage Canada', 'haute', 'en_cours', 0.00, 420000.00, 11.00, '', '2025-12-05', '2025-08-05 08:10:58'),
(35, 27, 1, NULL, 'biens_existant', 'Épargne simulée pour bien acquis', 'haute', 'atteint', 100.00, 0.00, 0.00, 'Structure patrimoniale de démarrage', '2025-08-14', '2025-08-14 13:49:11'),
(36, 28, 1, NULL, 'biens_existant', 'Épargne simulée pour bien acquis', 'haute', 'atteint', 100.00, 0.00, 0.00, 'Structure patrimoniale de démarrage', '2025-08-14', '2025-08-14 14:07:30'),
(37, 29, 1, NULL, 'biens_existant', 'Épargne simulée pour bien acquis', 'haute', 'atteint', 100.00, 0.00, 0.00, 'Structure patrimoniale de démarrage', '2025-08-14', '2025-08-14 15:03:58');

--
-- Déclencheurs `epargne_ct`
--
DELIMITER $$
CREATE TRIGGER `DetecterAlerteEpargneCT` BEFORE UPDATE ON `epargne_ct` FOR EACH ROW BEGIN
    IF NEW.statut = 'en_cours' AND DATEDIFF(NEW.date_echeance, CURDATE()) <= 7 AND NEW.montant_actuel < NEW.montant_vise THEN
        INSERT INTO alertes_Epargne_CT (
            id_epargne_ct,
            date_alerte,
            type_alerte,
            niveau_priorité,
            message
        )
        VALUES (
            NEW.id_epargne_ct,
            CURDATE(),
            'Épargne en danger',
            'haute',
            CONCAT('L’épargne pour "', NEW.objectif, '" est insuffisante à moins de 7 jours de l’échéance.')
        );
    END IF;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `MajProgressionEpargne` BEFORE UPDATE ON `epargne_ct` FOR EACH ROW BEGIN
  SET NEW.taux_progression = ROUND((NEW.montant_actuel / NEW.montant_vise) * 100, 2);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `financer`
--

CREATE TABLE `financer` (
  `id_financer` int(11) NOT NULL,
  `id_revenu` int(11) DEFAULT NULL,
  `id_gain` int(11) NOT NULL,
  `id_depense` int(11) DEFAULT NULL,
  `libelle_financement` varchar(255) DEFAULT NULL,
  `montant_f` decimal(12,2) DEFAULT NULL,
  `date_financer` date DEFAULT NULL,
  `heure_financer` time DEFAULT NULL,
  `type_financement` enum('Direct','Indirect','Mixte') DEFAULT NULL,
  `objectif_financement` enum('Logement','Education','Loisir','Investissement','Urgent','Régularisation','Nutrition','Énergie','Transport','Communication','Autre','Social extérieur','Social famille') DEFAULT NULL,
  `duree_financement` enum('Ponctuel','Journalier','Hebdomadaire','Mensuel','Trimestriel','Annuel','Autre') DEFAULT 'Ponctuel',
  `impact_financier` enum('Réduction_dépenses','Augmentation_rendement','Rééquilibrage','Stabilisation','Dépense faible','Dépense moyen','Dépense forte','Autre','Aucun') DEFAULT 'Aucun',
  `methode_allocation` enum('Prioritaire','Equilibrée','Aléatoire','Planifiée') DEFAULT NULL,
  `date_enregistrement` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déclencheurs `financer`
--
DELIMITER $$
CREATE TRIGGER `AfterDeleteFinancer_RestitutionRevenu` AFTER DELETE ON `financer` FOR EACH ROW BEGIN
  DECLARE montant_a_restituer DECIMAL(15,2);

  -- Vérifie que le financement était lié à un revenu
  IF OLD.id_revenu IS NOT NULL THEN
    SET montant_a_restituer = OLD.montant_f;

    -- Restitue le montant au revenu
    UPDATE revenus
    SET montant = montant + montant_a_restituer
    WHERE id_revenu = OLD.id_revenu;
  END IF;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `AfterInsertFinancer_PrioriteRevenu` AFTER INSERT ON `financer` FOR EACH ROW BEGIN

  DECLARE solde_revenu DECIMAL(15,2);

  DECLARE solde_gain DECIMAL(15,2);

  DECLARE montant_a_deduire DECIMAL(15,2);

  -- Récupération des soldes

  SELECT montant INTO solde_revenu

  FROM revenus

  WHERE id_revenu = NEW.id_revenu;

  SELECT montant_gain INTO solde_gain

  FROM gains

  WHERE id_gain = NEW.id_gain;

  SET montant_a_deduire = NEW.montant_f;

  -- Déduction prioritaire sur le revenu

  IF solde_revenu >= montant_a_deduire THEN

    UPDATE revenus

    SET montant = montant - montant_a_deduire

    WHERE id_revenu = NEW.id_revenu;

  ELSE

    -- Consommer tout le revenu disponible

    UPDATE revenus

    SET montant = 0

    WHERE id_revenu = NEW.id_revenu;

    -- Déduire le reste sur le gain

    UPDATE gains

    SET montant_gain = montant_gain - (montant_a_deduire - solde_revenu)

    WHERE id_gain = NEW.id_gain;

  END IF;

END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `gains`
--

CREATE TABLE `gains` (
  `id_gain` int(11) NOT NULL,
  `id_bien` int(11) DEFAULT NULL,
  `montant_gain` decimal(12,2) DEFAULT NULL,
  `libelle_gain` varchar(250) DEFAULT NULL,
  `source_gain` varchar(250) DEFAULT NULL,
  `date_gain` date DEFAULT NULL,
  `date_enregistrement` datetime DEFAULT current_timestamp(),
  `type_gain` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `frequence` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `moyen_de_gain` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `taux_rendement` decimal(5,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `gains`
--

INSERT INTO `gains` (`id_gain`, `id_bien`, `montant_gain`, `libelle_gain`, `source_gain`, `date_gain`, `date_enregistrement`, `type_gain`, `frequence`, `moyen_de_gain`, `taux_rendement`) VALUES
(22, 2, 0.00, 'Gain Null', NULL, '2025-07-20', '2025-07-20 08:39:31', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `journal_financements`
--

CREATE TABLE `journal_financements` (
  `id_journal` int(11) NOT NULL,
  `id_financer` int(11) NOT NULL,
  `date_enregistrement` datetime DEFAULT current_timestamp(),
  `source_fonds` varchar(50) DEFAULT NULL,
  `cible` varchar(100) DEFAULT NULL,
  `conformite` enum('valide','non conforme','à surveiller') DEFAULT NULL,
  `remarque` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `paliers_pedagogiques_budget`
--

CREATE TABLE `paliers_pedagogiques_budget` (
  `id_palier` int(11) NOT NULL,
  `tranche_score` varchar(20) DEFAULT NULL,
  `nom_palier` varchar(50) DEFAULT NULL,
  `message_pedagogique` text DEFAULT NULL,
  `module_apprentissage` text DEFAULT NULL,
  `acces_debloque` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `paliers_pedagogiques_budget`
--

INSERT INTO `paliers_pedagogiques_budget` (`id_palier`, `tranche_score`, `nom_palier`, `message_pedagogique`, `module_apprentissage`, `acces_debloque`) VALUES
(1, '0-49', 'Novice patrimonial', 'Tu débutes ton parcours. Commence par les règles fondamentales de discipline budgétaire.', 'Initiation à l’épargne disciplinée', 'Accès à module \"Budget de survie\"'),
(2, '50-74', 'Discipline naissante', 'Tu gagnes en maîtrise mais ta rigueur reste instable.', 'Formation sur contrôle des dépenses', 'Accès au simulateur de flux'),
(3, '75-89', 'Patrimonial confirmé', 'Excellente discipline. Tu peux affiner tes stratégies d’investissement.', 'Module d’optimisation des gains', 'Déblocage du tableau de bord comparatif'),
(4, '90-100', 'Maître stratégique', 'Tu maîtrises pleinement ton budget. Ton profil est exemplaire.', 'Mentorat patrimonial & challenge premium', 'Accès aux concours stratégiques');

-- --------------------------------------------------------

--
-- Structure de la table `parcours_progression_utilisateur`
--

CREATE TABLE `parcours_progression_utilisateur` (
  `id_progression` int(11) NOT NULL,
  `id_utilisateur` int(11) DEFAULT NULL,
  `palier_atteint` varchar(50) DEFAULT NULL,
  `date_validation` date DEFAULT NULL,
  `module_reussi` varchar(100) DEFAULT NULL,
  `score_module` decimal(5,2) DEFAULT NULL,
  `badge_obtenu` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `pertes`
--

CREATE TABLE `pertes` (
  `id_engendrer_pertes` int(11) NOT NULL,
  `id_bien` int(11) DEFAULT NULL,
  `montant_perte` decimal(12,2) DEFAULT NULL,
  `cause_perte` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `frequence` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `responsable_incident` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `nature_perte` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_perte` date DEFAULT NULL,
  `date_enregistrement` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `pertes`
--

INSERT INTO `pertes` (`id_engendrer_pertes`, `id_bien`, `montant_perte`, `cause_perte`, `frequence`, `responsable_incident`, `nature_perte`, `date_perte`, `date_enregistrement`) VALUES
(13, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:22:14'),
(14, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:22:55'),
(15, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:29:03'),
(16, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:29:13'),
(17, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:35:27'),
(18, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:37:44'),
(19, 1, 45000.00, NULL, NULL, NULL, NULL, '2025-07-20', '2025-07-20 08:39:31');

-- --------------------------------------------------------

--
-- Structure de la table `profil_comportement_utilisateur`
--

CREATE TABLE `profil_comportement_utilisateur` (
  `id_profil` int(11) NOT NULL,
  `id_utilisateur` int(11) NOT NULL,
  `mois` int(11) DEFAULT NULL,
  `annee` int(11) DEFAULT NULL,
  `nb_sessions` int(11) DEFAULT NULL,
  `duree_totale_minutes` decimal(6,2) DEFAULT NULL,
  `frequence_connexion` enum('rare','modérée','fréquente') DEFAULT NULL,
  `regularite` enum('irrégulière','stable','exemplaire') DEFAULT NULL,
  `score_engagement` decimal(5,2) DEFAULT NULL,
  `badge_comportement` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `profil_comportement_utilisateur`
--

INSERT INTO `profil_comportement_utilisateur` (`id_profil`, `id_utilisateur`, `mois`, `annee`, `nb_sessions`, `duree_totale_minutes`, `frequence_connexion`, `regularite`, `score_engagement`, `badge_comportement`) VALUES
(1, 2, 8, 2025, 40, 2737.23, 'fréquente', 'exemplaire', 0.00, NULL),
(5, 27, 8, 2025, 2, NULL, 'rare', 'irrégulière', 0.00, NULL),
(6, 28, 8, 2025, 1, NULL, 'rare', 'irrégulière', 0.00, NULL),
(7, 29, 8, 2025, 1, NULL, 'rare', 'irrégulière', 0.00, NULL),
(8, 2, 8, 2025, 40, 2737.23, 'fréquente', 'exemplaire', 0.00, NULL),
(12, 27, 8, 2025, 2, NULL, 'rare', 'irrégulière', 0.00, NULL),
(13, 28, 8, 2025, 1, NULL, 'rare', 'irrégulière', 0.00, NULL),
(14, 29, 8, 2025, 1, NULL, 'rare', 'irrégulière', 0.00, NULL),
(15, 2, 8, 2025, 40, 2737.23, 'fréquente', 'exemplaire', 0.00, NULL),
(19, 27, 8, 2025, 2, NULL, 'rare', 'irrégulière', 0.00, NULL),
(20, 28, 8, 2025, 1, NULL, 'rare', 'irrégulière', 0.00, NULL),
(21, 29, 8, 2025, 1, NULL, 'rare', 'irrégulière', 0.00, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `recommandations_score_budget`
--

CREATE TABLE `recommandations_score_budget` (
  `id_reco` int(11) NOT NULL,
  `tranche_score` varchar(20) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `action_conseillee` text DEFAULT NULL,
  `niveau_priorite` enum('faible','modéré','élevé') DEFAULT 'modéré',
  `active` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `recommandations_score_budget`
--

INSERT INTO `recommandations_score_budget` (`id_reco`, `tranche_score`, `message`, `action_conseillee`, `niveau_priorite`, `active`) VALUES
(1, '0-49', 'Votre discipline patrimoniale est fragile ce mois-ci.', 'Identifiez les postes budgétaires critiques et réduisez vos dépenses variables.', 'modéré', 1),
(2, '50-74', 'Performance budgétaire moyenne. Il y a matière à progrès.', 'Augmentez vos apports vers l’épargne stratégique.', 'modéré', 1),
(3, '75-89', 'Très bonne maîtrise !', 'Maintenez ce rythme et envisagez d’investir dans un bien stratégique.', 'modéré', 1),
(4, '90-100', 'Discipline budgétaire exemplaire !', 'Vous pouvez servir de profil de référence pour les autres membres.', 'modéré', 1);

-- --------------------------------------------------------

--
-- Structure de la table `revenus`
--

CREATE TABLE `revenus` (
  `id_revenu` int(11) NOT NULL,
  `id_receveur` int(11) DEFAULT NULL,
  `id_donneur` int(11) DEFAULT NULL,
  `id_compte` int(11) DEFAULT NULL,
  `montant` decimal(12,2) DEFAULT NULL,
  `source` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `libelle_revenu` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `categorie_revenu` enum('Salaire','Revenu_activite','Revenu_passif','Don','Aide','Subvention','Remboursement','Rétro commission','Autre') NOT NULL,
  `mode_paiement` enum('Virement','Espèces','Chèque','Mobile_money','Autre') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `frequence` enum('Journalière','Hebdomadaire','Mensuelle','Trimestrielle','Semestrielle','Annuelle','Alternative','Unique','Ponctuel','Irrégulier') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `commentaires` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `responsable_suivi` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `justificatif` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `reference_transaction` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_revenu` date DEFAULT NULL,
  `statut` enum('Prévu','Encaissé','Annulé','Actif','Prévisionnel','Expiré','Suspendu') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_enregistrement` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `revenus`
--

INSERT INTO `revenus` (`id_revenu`, `id_receveur`, `id_donneur`, `id_compte`, `montant`, `source`, `libelle_revenu`, `categorie_revenu`, `mode_paiement`, `frequence`, `commentaires`, `responsable_suivi`, `justificatif`, `reference_transaction`, `date_revenu`, `statut`, `date_enregistrement`) VALUES
(1, 2, 1, 1, 74001.00, 'MINESEC ', 'Salaire ', 'Salaire', 'Espèces', 'Mensuelle', 'RAS ', 'Moi-même ', 'Voir listing CCA online bank', 'Voir CCA online bank ', '2025-07-26', 'Encaissé', '2025-08-03 21:58:17'),
(2, 2, 1, 5, 12000.00, 'Prestations de services informatiques à BK Business Bali', 'Bénéfice travaux', 'Revenu_activite', 'Espèces', 'Unique', 'hgh', 'BK Business Bali ', 'Listing transaction orange money', 'Voir listing ', '2025-07-18', 'Encaissé', '2025-08-03 21:58:17'),
(3, 2, 1, 6, 1.00, 'Relationnelle', 'Commission LYBIBO / ', 'Rétro commission', 'Mobile_money', 'Alternative', 'fhfd', 'fgf', 'ghg', 'fgf', '2025-08-12', 'Encaissé', '2025-08-05 16:18:53');

-- --------------------------------------------------------

--
-- Structure de la table `revenus_biens`
--

CREATE TABLE `revenus_biens` (
  `id_revenus_biens` int(11) NOT NULL,
  `id_bien` int(11) DEFAULT NULL,
  `libelle_revenu_bien` varchar(255) DEFAULT NULL,
  `montant_revenu` decimal(12,2) DEFAULT NULL,
  `type_revenu_bien` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `origine_revenu` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `frequence` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `responsable_collecte` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `justificatif` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `mois_revenu` enum('Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `annee_revenu` varchar(11) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_enregistrement` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `revenus_biens`
--

INSERT INTO `revenus_biens` (`id_revenus_biens`, `id_bien`, `libelle_revenu_bien`, `montant_revenu`, `type_revenu_bien`, `origine_revenu`, `frequence`, `responsable_collecte`, `justificatif`, `mois_revenu`, `annee_revenu`, `date_enregistrement`) VALUES
(11, 1, 'Vente appartement bertoua', 5000000.00, 'T', 'T', 'Mensuelle', 'T', 'T', 'Décembre', '2025', '2025-06-19 00:00:00');

-- --------------------------------------------------------

--
-- Structure de la table `score_budget_patrimonial`
--

CREATE TABLE `score_budget_patrimonial` (
  `id_score` int(11) NOT NULL,
  `id_utilisateur` int(11) NOT NULL,
  `mois` int(11) NOT NULL,
  `annee` int(11) NOT NULL,
  `total_revenus` decimal(12,2) DEFAULT NULL,
  `total_depenses` decimal(12,2) DEFAULT NULL,
  `total_epargne` decimal(12,2) DEFAULT NULL,
  `score_global` decimal(5,2) DEFAULT NULL,
  `interpretation` text DEFAULT NULL,
  `badge_attribue` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `score_stabilite_comptes`
--

CREATE TABLE `score_stabilite_comptes` (
  `id_score` int(11) NOT NULL,
  `id_utilisateur` int(11) DEFAULT NULL,
  `id_compte` int(11) DEFAULT NULL,
  `mois` int(11) DEFAULT NULL,
  `annee` int(11) DEFAULT NULL,
  `solde_final` decimal(12,2) DEFAULT NULL,
  `ratio_utilisation` decimal(5,2) DEFAULT NULL,
  `depassement_decouvert` tinyint(1) DEFAULT NULL,
  `score_stabilite` decimal(5,2) DEFAULT NULL,
  `commentaire` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `sessions`
--

CREATE TABLE `sessions` (
  `id_session` int(11) NOT NULL,
  `id_utilisateur` int(11) DEFAULT NULL,
  `date_connexion` date DEFAULT NULL,
  `heure_connexion` time DEFAULT NULL,
  `date_deconnexion` date DEFAULT NULL,
  `heure_deconnexion` time DEFAULT NULL,
  `adresse_ip` varchar(45) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `localisation` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `type_appareil` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `infos_navigateur` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `duree_session` time DEFAULT NULL,
  `statut_session` enum('active','fermee') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `sessions`
--

INSERT INTO `sessions` (`id_session`, `id_utilisateur`, `date_connexion`, `heure_connexion`, `date_deconnexion`, `heure_deconnexion`, `adresse_ip`, `localisation`, `type_appareil`, `infos_navigateur`, `duree_session`, `statut_session`) VALUES
(1, 1, '2025-07-19', '02:02:29', NULL, NULL, '192.168.1.1', 'Douala Cameroun', 'Android ', 'Google Chrome ', NULL, 'active'),
(24, 2, '2025-08-11', '17:55:13', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', NULL, 'active'),
(25, 2, '2025-08-11', '22:42:03', '2025-08-13', '00:34:18', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '25:52:15', 'fermee'),
(26, 2, '2025-08-13', '00:34:20', '2025-08-13', '00:34:23', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '00:00:03', 'fermee'),
(27, 2, '2025-08-13', '00:34:56', '2025-08-13', '01:00:54', '127.0.0.1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0', '00:25:58', 'fermee'),
(28, 2, '2025-08-13', '00:41:17', '2025-08-13', '01:02:31', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '00:21:14', 'fermee'),
(29, 2, '2025-08-13', '01:00:55', NULL, NULL, '127.0.0.1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0', NULL, 'active'),
(30, 2, '2025-08-13', '01:02:33', '2025-08-13', '02:16:57', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '01:14:24', 'fermee'),
(31, 2, '2025-08-13', '02:16:58', '2025-08-13', '02:32:16', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '00:15:18', 'fermee'),
(32, 2, '2025-08-13', '02:32:17', '2025-08-13', '02:38:09', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '00:05:52', 'fermee'),
(33, 2, '2025-08-13', '02:38:10', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', NULL, 'active'),
(34, 2, '2025-08-13', '02:38:10', '2025-08-13', '03:09:10', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '00:31:00', 'fermee'),
(35, 2, '2025-08-13', '03:09:11', '2025-08-13', '06:27:19', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '03:18:08', 'fermee'),
(36, 2, '2025-08-13', '06:27:20', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', NULL, 'active'),
(37, 2, '2025-08-13', '06:38:25', '2025-08-13', '06:38:26', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', '00:00:01', 'fermee'),
(38, 2, '2025-08-13', '06:38:27', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0', NULL, 'active'),
(39, 2, '2025-08-13', '16:48:15', '2025-08-13', '21:51:37', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '05:03:22', 'fermee'),
(40, 2, '2025-08-13', '16:49:52', NULL, NULL, '127.0.0.1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0', NULL, 'active'),
(41, 2, '2025-08-13', '21:51:39', '2025-08-13', '23:12:09', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '01:20:30', 'fermee'),
(42, 2, '2025-08-13', '23:12:10', '2025-08-14', '00:36:10', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '01:24:00', 'fermee'),
(43, 2, '2025-08-14', '00:38:05', '2025-08-14', '00:38:40', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '00:00:35', 'fermee'),
(44, 2, '2025-08-14', '00:44:49', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', NULL, 'active'),
(45, 2, '2025-08-14', '00:44:49', '2025-08-14', '01:24:25', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '00:39:36', 'fermee'),
(46, 2, '2025-08-14', '01:24:26', '2025-08-14', '01:37:15', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '00:12:49', 'fermee'),
(47, 2, '2025-08-14', '01:37:16', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', NULL, 'active'),
(48, 2, '2025-08-14', '01:37:16', '2025-08-14', '01:43:04', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '00:05:48', 'fermee'),
(49, 2, '2025-08-14', '01:43:06', '2025-08-14', '02:04:21', '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', '00:21:15', 'fermee'),
(50, 2, '2025-08-14', '02:04:22', NULL, NULL, '::1', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', NULL, 'active'),
(51, 2, '2025-08-14', '10:23:51', NULL, NULL, '102.244.223.29', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 'active'),
(52, 2, '2025-08-14', '10:55:26', '2025-08-14', '12:29:06', '102.244.223.29', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '01:33:40', 'fermee'),
(53, 2, '2025-08-14', '12:29:24', '2025-08-14', '12:29:26', '102.244.223.29', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00:00:02', 'fermee'),
(54, 2, '2025-08-14', '12:29:41', '2025-08-14', '13:05:15', '102.244.223.29', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00:35:34', 'fermee'),
(55, 2, '2025-08-14', '13:21:44', '2025-08-14', '13:21:47', '102.244.223.29', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00:00:03', 'fermee'),
(59, 27, '2025-08-14', '13:49:26', NULL, NULL, '129.0.99.231', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', NULL, 'active'),
(60, 27, '2025-08-14', '13:52:52', NULL, NULL, '129.0.99.231', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', NULL, 'active'),
(63, 28, '2025-08-14', '14:07:51', NULL, NULL, '102.244.128.105', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', NULL, 'active'),
(64, 29, '2025-08-14', '15:04:17', NULL, NULL, '41.202.219.160', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', NULL, 'active'),
(68, 2, '2025-08-15', '00:21:14', '2025-08-15', '00:56:34', '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', '00:35:20', 'fermee'),
(69, 2, '2025-08-15', '00:33:44', NULL, NULL, '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 'active'),
(70, 2, '2025-08-15', '00:56:38', '2025-08-15', '02:07:08', '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', '01:10:30', 'fermee'),
(71, 2, '2025-08-15', '01:20:33', '2025-08-15', '01:48:59', '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00:28:26', 'fermee'),
(72, 2, '2025-08-15', '01:49:01', '2025-08-15', '01:50:32', '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '00:01:31', 'fermee'),
(73, 2, '2025-08-15', '01:50:58', NULL, NULL, '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 'active'),
(74, 2, '2025-08-15', '02:07:11', NULL, NULL, '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', NULL, 'active'),
(75, 2, '2025-08-16', '07:52:27', NULL, NULL, '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 'active'),
(76, 2, '2025-08-16', '09:55:01', NULL, NULL, '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 'active'),
(77, 2, '2025-08-16', '09:55:02', NULL, NULL, '102.244.221.208', 'Douala, Cameroun', 'Desktop/Tablette/Mobile', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', NULL, 'active');

-- --------------------------------------------------------

--
-- Structure de la table `simulation_remboursement`
--

CREATE TABLE `simulation_remboursement` (
  `id_simulation` int(11) NOT NULL,
  `id_dette` int(11) NOT NULL,
  `mois_simulation` date NOT NULL,
  `montant_du` int(11) DEFAULT NULL,
  `montant_simule` decimal(12,2) DEFAULT NULL,
  `interet_mensuel_estime` decimal(12,2) DEFAULT NULL,
  `pression_pat_mensuelle` enum('faible','moyenne','élevée') DEFAULT NULL,
  `statut_simulation` enum('prévision','réalisée','ajustée') DEFAULT NULL,
  `commentaire` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Structure de la table `suggestions_affectation_revenus`
--

CREATE TABLE `suggestions_affectation_revenus` (
  `id_suggestion` int(11) NOT NULL,
  `id_revenu` int(11) NOT NULL,
  `date_suggestion` date NOT NULL,
  `destination_prioritaire` varchar(100) DEFAULT NULL,
  `justification` text DEFAULT NULL,
  `statut` enum('proposée','acceptée','ignorée') DEFAULT 'proposée'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `suggestions_affectation_revenus`
--

INSERT INTO `suggestions_affectation_revenus` (`id_suggestion`, `id_revenu`, `date_suggestion`, `destination_prioritaire`, `justification`, `statut`) VALUES
(1, 1, '2025-08-05', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(2, 2, '2025-08-05', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(3, 3, '2025-08-05', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(4, 1, '2025-08-05', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(5, 2, '2025-08-05', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(6, 3, '2025-08-05', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(7, 1, '2025-08-16', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(8, 2, '2025-08-16', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(9, 3, '2025-08-16', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(10, 1, '2025-08-16', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(11, 2, '2025-08-16', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée'),
(12, 3, '2025-08-16', 'Épargne_CT', 'Affectation prioritaire recommandée selon ton conseil de discipline : les revenus alimentent l’épargne dédiée à acquisition de biens.', 'proposée');

-- --------------------------------------------------------

--
-- Structure de la table `utilisateurs`
--

CREATE TABLE `utilisateurs` (
  `id_utilisateur` int(11) NOT NULL,
  `nom` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `prenom` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `mot_de_passe` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `genre` varchar(10) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date_naissance` date DEFAULT NULL,
  `niveau_education` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `profession` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `type_utilisateur` enum('admin','simple','analyste') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `motivation_financiere` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `profil_risque` enum('faible','moyen','élevé') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `score_fidelite` int(11) DEFAULT NULL,
  `statut` enum('actif','inactif') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `derniere_connexion` datetime DEFAULT NULL,
  `nombre_sessions` int(11) DEFAULT NULL,
  `date_creation` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Déchargement des données de la table `utilisateurs`
--

INSERT INTO `utilisateurs` (`id_utilisateur`, `nom`, `prenom`, `email`, `mot_de_passe`, `genre`, `date_naissance`, `niveau_education`, `profession`, `type_utilisateur`, `motivation_financiere`, `profil_risque`, `score_fidelite`, `statut`, `derniere_connexion`, `nombre_sessions`, `date_creation`) VALUES
(1, 'Admin App', 'Compte par défaut', 'admin@gespes360.com', '$2y$10$SGbAY6Fves7FzEjpRsLRZO1jaff2nvrS0HC/.zE2fr8NZz8PGfH9y', 'Masculin', '2025-07-08', 'Master II', 'Enseignant Informaticien', 'simple', 'Stabilité financière', 'moyen', 10, 'actif', '2025-07-01 16:17:54', 2, '2025-07-18 15:21:47'),
(2, 'NDADJE EYAMBE', 'Narcisse', 'ndadjeeyamben@gmail.com', '$2y$10$SGbAY6Fves7FzEjpRsLRZO1jaff2nvrS0HC/.zE2fr8NZz8PGfH9y', 'Masculin', '1993-02-23', 'Master II', 'Enseignant d\'informatique et chef d\'entreprise', 'simple', 'Riche', 'faible', 10, 'actif', '2025-08-16 09:55:02', 44, '2025-07-19 01:35:02'),
(27, 'Simo', 'Brenda ', 'brendasimo598@gmail.com', '$2y$10$yUfroCODpYS.pVsHXKr5Q.d.AY7/MpvABWrmdXfCQTGfLOF4FVdKG', 'Féminin', '2004-08-14', '', 'Étudiante', 'simple', '', 'faible', 10, 'actif', '2025-08-14 13:52:52', 2, '2025-08-14 12:49:11'),
(28, 'FAUT ', 'DÉVELOPPER ', 'fautdevelopper@gmail.com', '$2y$10$fvDr9bWedcqTXGfiyPAFfuN3HuV.wexIpaxg0qHQjHIgG6wcxF94W', 'Masculin', '2004-05-15', 'Baccalauréat ', 'Étudiant ', 'simple', 'Réaliser mes projets et Rêves ', 'élevé', 10, 'actif', '2025-08-14 14:07:51', 1, '2025-08-14 13:07:30'),
(29, 'Etogo', 'Landry', 'landrymavericketogo@gmail.com', '$2y$10$edsjwCOyk98by4SChFOfO.SC8OSUsT7cpUQ9/hVypc/nkBdnvJ1TK', 'Masculin', '1989-07-08', 'Bac +3', 'Enseignant', 'simple', '', 'faible', 10, 'actif', '2025-08-14 15:04:17', 1, '2025-08-14 14:03:58');

--
-- Déclencheurs `utilisateurs`
--
DELIMITER $$
CREATE TRIGGER `AfterInsertUtilisateur` AFTER INSERT ON `utilisateurs` FOR EACH ROW BEGIN
  CALL InitialiserStructuresUtilisateur(
    NEW.id_utilisateur,
    1
  );
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `AppliquerConseilsApresAjout` AFTER INSERT ON `utilisateurs` FOR EACH ROW BEGIN
    CALL AjouterConseilsParDefaut(NEW.id_utilisateur);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_analysemensuelledettes`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_analysemensuelledettes` (
`id_dette` int(11)
,`contracteur` varchar(100)
,`montant_emprunt` decimal(12,2)
,`montant_remboursement` decimal(12,2)
,`progression_remboursement` decimal(18,2)
,`taux_d_interest` decimal(5,2)
,`interet_restant` decimal(17,2)
,`date_emprunt` date
,`date_remboursement` date
,`statut` enum('active','remboursée','annulée')
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_bilancomptesmensuel`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_bilancomptesmensuel` (
`id_utilisateur` int(11)
,`utilisateur` varchar(100)
,`type_compte` enum('courant','épargne','investissement','salaire','caisse','poche')
,`solde_total` decimal(34,2)
,`nombre_comptes` bigint(21)
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_classement_budget_mensuel`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_classement_budget_mensuel` (
`pseudonyme` varchar(23)
,`score_global` decimal(5,2)
,`badge_attribue` varchar(50)
,`mois` int(11)
,`annee` int(11)
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_comparaison_mensuelle`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_comparaison_mensuelle` (
`id_bien` int(11)
,`type_bien` enum('Résidence principale','Résidence secondaire','Terrain non bâti','Immeuble locatif','Local commercial','Bien en copropriété','Bien en construction','Véhicule personnel','Véhicule professionnel','Matériel informatique','Équipement professionnel','Mobilier résidentiel','Action cotée','Action non cotée','Obligation','Fonds d’investissement','Crypto-actif','Contrat d’assurance-vie','Part sociale','Fonds de commerce','Licence d’exploitation','Machine professionnelle','Stock valorisé','Franchise commerciale','Marque déposée','Logiciel développé','Droit d’auteur','Bien en indivision','Bien en démembrement','Bien hypothéqué','Bien acquis par donation','Bien bénéficiant d’un régime fiscal','Epoux/epouse')
,`mois_precedent` date
,`produit_mois_precedent` decimal(12,2)
,`mois_courant` date
,`produit_mois_courant` decimal(12,2)
,`variation` decimal(13,2)
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_conseils_strategiques`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_conseils_strategiques` (
`id_utilisateur` int(11)
,`type_conseil` varchar(50)
,`message_conseil` longtext
,`date_generation` datetime
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_profile_strategique`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_profile_strategique` (
`id_utilisateur` int(11)
,`nom` varchar(100)
,`score_fidelite` int(11)
,`score_global` decimal(5,2)
,`palier_atteint` varchar(50)
,`message_conseil` longtext
,`suggestion_active` text
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_progression_epargne`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_progression_epargne` (
`id_epargne_ct` int(11)
,`objectif` varchar(255)
,`progression_effective` decimal(18,2)
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_stats_sessions_mensuelles`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_stats_sessions_mensuelles` (
`id_utilisateur` int(11)
,`nb_sessions` bigint(21)
,`durée_moyenne_minutes` decimal(24,8)
,`derniere_connexion` date
);

-- --------------------------------------------------------

--
-- Doublure de structure pour la vue `vue_taux_rendementmensuel`
-- (Voir ci-dessous la vue réelle)
--
CREATE TABLE `vue_taux_rendementmensuel` (
`id_bien` int(11)
,`type_bien` enum('Résidence principale','Résidence secondaire','Terrain non bâti','Immeuble locatif','Local commercial','Bien en copropriété','Bien en construction','Véhicule personnel','Véhicule professionnel','Matériel informatique','Équipement professionnel','Mobilier résidentiel','Action cotée','Action non cotée','Obligation','Fonds d’investissement','Crypto-actif','Contrat d’assurance-vie','Part sociale','Fonds de commerce','Licence d’exploitation','Machine professionnelle','Stock valorisé','Franchise commerciale','Marque déposée','Logiciel développé','Droit d’auteur','Bien en indivision','Bien en démembrement','Bien hypothéqué','Bien acquis par donation','Bien bénéficiant d’un régime fiscal','Epoux/epouse')
,`montant_acquisition` decimal(12,2)
,`gain_mensuel` decimal(34,2)
,`taux_rendement` decimal(40,2)
);

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `actions_patrimoniales_recommandees`
--
ALTER TABLE `actions_patrimoniales_recommandees`
  ADD PRIMARY KEY (`id_action`),
  ADD KEY `id_epargne_ct` (`id_epargne_ct`);

--
-- Index pour la table `alertes_comptes`
--
ALTER TABLE `alertes_comptes`
  ADD PRIMARY KEY (`id_alerte`),
  ADD KEY `id_compte` (`id_compte`);

--
-- Index pour la table `alertes_depenses`
--
ALTER TABLE `alertes_depenses`
  ADD PRIMARY KEY (`id_alerte`),
  ADD KEY `id_faiseur` (`id_faiseur`);

--
-- Index pour la table `alertes_depots_epargne`
--
ALTER TABLE `alertes_depots_epargne`
  ADD PRIMARY KEY (`id_alerte`);

--
-- Index pour la table `alertes_dettes`
--
ALTER TABLE `alertes_dettes`
  ADD PRIMARY KEY (`id_alerte_dette`),
  ADD KEY `id_dette` (`id_dette`);

--
-- Index pour la table `alertes_epargne_ct`
--
ALTER TABLE `alertes_epargne_ct`
  ADD PRIMARY KEY (`id_alerte_ct`),
  ADD KEY `id_epargne_ct` (`id_epargne_ct`);

--
-- Index pour la table `alertes_patrimoniales`
--
ALTER TABLE `alertes_patrimoniales`
  ADD PRIMARY KEY (`id_alerte`),
  ADD KEY `id_bien` (`id_bien`);

--
-- Index pour la table `alertes_revenus`
--
ALTER TABLE `alertes_revenus`
  ADD PRIMARY KEY (`id_alerte`),
  ADD KEY `id_revenu` (`id_revenu`);

--
-- Index pour la table `biens`
--
ALTER TABLE `biens`
  ADD PRIMARY KEY (`id_bien`),
  ADD KEY `id_epargne_ct` (`id_epargne_ct`),
  ADD KEY `id_dette` (`id_dette`);

--
-- Index pour la table `bilans_patrimoniaux`
--
ALTER TABLE `bilans_patrimoniaux`
  ADD PRIMARY KEY (`id_bilan`),
  ADD KEY `id_bien` (`id_bien`);

--
-- Index pour la table `coaching_budget_personnalise`
--
ALTER TABLE `coaching_budget_personnalise`
  ADD PRIMARY KEY (`id_coaching`),
  ADD KEY `id_utilisateur` (`id_utilisateur`);

--
-- Index pour la table `comptes`
--
ALTER TABLE `comptes`
  ADD PRIMARY KEY (`id_compte`),
  ADD KEY `id_utilisateur` (`id_utilisateur`);

--
-- Index pour la table `conseils`
--
ALTER TABLE `conseils`
  ADD PRIMARY KEY (`id_conseil`),
  ADD KEY `Conseils_ibfk_1` (`id_utilisateur`);

--
-- Index pour la table `conseils_epargne`
--
ALTER TABLE `conseils_epargne`
  ADD PRIMARY KEY (`id_conseil_ct`);

--
-- Index pour la table `depenses`
--
ALTER TABLE `depenses`
  ADD PRIMARY KEY (`id_depense`),
  ADD KEY `id_faiseur` (`id_faiseur`),
  ADD KEY `id_receveur` (`id_receveur`);

--
-- Index pour la table `depenses_biens`
--
ALTER TABLE `depenses_biens`
  ADD PRIMARY KEY (`id_depenses_biens`),
  ADD KEY `id_bien` (`id_bien`);

--
-- Index pour la table `dettes`
--
ALTER TABLE `dettes`
  ADD PRIMARY KEY (`id_dette`),
  ADD KEY `id_contracteur` (`id_contracteur`),
  ADD KEY `id_octroyeur` (`id_octroyeur`),
  ADD KEY `id_compte` (`id_compte`);

--
-- Index pour la table `epargner`
--
ALTER TABLE `epargner`
  ADD PRIMARY KEY (`id_epargner`),
  ADD KEY `id_revenu` (`id_revenu`),
  ADD KEY `id_gain` (`id_gain`) USING BTREE,
  ADD KEY `id_epargne_ct` (`id_epargne_ct`) USING BTREE;

--
-- Index pour la table `epargne_ct`
--
ALTER TABLE `epargne_ct`
  ADD PRIMARY KEY (`id_epargne_ct`),
  ADD KEY `id_utilisateur` (`id_utilisateur`),
  ADD KEY `id_compte` (`id_compte`);

--
-- Index pour la table `financer`
--
ALTER TABLE `financer`
  ADD PRIMARY KEY (`id_financer`),
  ADD KEY `id_revenu` (`id_revenu`),
  ADD KEY `id_depense` (`id_depense`),
  ADD KEY `id_gain` (`id_gain`) USING BTREE;

--
-- Index pour la table `gains`
--
ALTER TABLE `gains`
  ADD PRIMARY KEY (`id_gain`),
  ADD KEY `id_bien` (`id_bien`);

--
-- Index pour la table `journal_financements`
--
ALTER TABLE `journal_financements`
  ADD PRIMARY KEY (`id_journal`),
  ADD KEY `id_financer` (`id_financer`);

--
-- Index pour la table `paliers_pedagogiques_budget`
--
ALTER TABLE `paliers_pedagogiques_budget`
  ADD PRIMARY KEY (`id_palier`);

--
-- Index pour la table `parcours_progression_utilisateur`
--
ALTER TABLE `parcours_progression_utilisateur`
  ADD PRIMARY KEY (`id_progression`),
  ADD KEY `id_utilisateur` (`id_utilisateur`);

--
-- Index pour la table `pertes`
--
ALTER TABLE `pertes`
  ADD PRIMARY KEY (`id_engendrer_pertes`),
  ADD KEY `id_bien` (`id_bien`);

--
-- Index pour la table `profil_comportement_utilisateur`
--
ALTER TABLE `profil_comportement_utilisateur`
  ADD PRIMARY KEY (`id_profil`),
  ADD KEY `id_utilisateur` (`id_utilisateur`);

--
-- Index pour la table `recommandations_score_budget`
--
ALTER TABLE `recommandations_score_budget`
  ADD PRIMARY KEY (`id_reco`);

--
-- Index pour la table `revenus`
--
ALTER TABLE `revenus`
  ADD PRIMARY KEY (`id_revenu`),
  ADD KEY `id_receveur` (`id_receveur`),
  ADD KEY `id_donneur` (`id_donneur`),
  ADD KEY `id_compte` (`id_compte`);

--
-- Index pour la table `revenus_biens`
--
ALTER TABLE `revenus_biens`
  ADD PRIMARY KEY (`id_revenus_biens`),
  ADD KEY `id_bien` (`id_bien`);

--
-- Index pour la table `score_budget_patrimonial`
--
ALTER TABLE `score_budget_patrimonial`
  ADD PRIMARY KEY (`id_score`),
  ADD KEY `id_utilisateur` (`id_utilisateur`);

--
-- Index pour la table `score_stabilite_comptes`
--
ALTER TABLE `score_stabilite_comptes`
  ADD PRIMARY KEY (`id_score`),
  ADD KEY `id_utilisateur` (`id_utilisateur`),
  ADD KEY `id_compte` (`id_compte`);

--
-- Index pour la table `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id_session`),
  ADD KEY `id_utilisateur` (`id_utilisateur`);

--
-- Index pour la table `simulation_remboursement`
--
ALTER TABLE `simulation_remboursement`
  ADD PRIMARY KEY (`id_simulation`),
  ADD KEY `id_dette` (`id_dette`);

--
-- Index pour la table `suggestions_affectation_revenus`
--
ALTER TABLE `suggestions_affectation_revenus`
  ADD PRIMARY KEY (`id_suggestion`),
  ADD KEY `id_revenu` (`id_revenu`);

--
-- Index pour la table `utilisateurs`
--
ALTER TABLE `utilisateurs`
  ADD PRIMARY KEY (`id_utilisateur`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT pour les tables déchargées
--

--
-- AUTO_INCREMENT pour la table `actions_patrimoniales_recommandees`
--
ALTER TABLE `actions_patrimoniales_recommandees`
  MODIFY `id_action` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `alertes_comptes`
--
ALTER TABLE `alertes_comptes`
  MODIFY `id_alerte` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT pour la table `alertes_depenses`
--
ALTER TABLE `alertes_depenses`
  MODIFY `id_alerte` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `alertes_depots_epargne`
--
ALTER TABLE `alertes_depots_epargne`
  MODIFY `id_alerte` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `alertes_dettes`
--
ALTER TABLE `alertes_dettes`
  MODIFY `id_alerte_dette` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `alertes_epargne_ct`
--
ALTER TABLE `alertes_epargne_ct`
  MODIFY `id_alerte_ct` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `alertes_patrimoniales`
--
ALTER TABLE `alertes_patrimoniales`
  MODIFY `id_alerte` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `alertes_revenus`
--
ALTER TABLE `alertes_revenus`
  MODIFY `id_alerte` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `biens`
--
ALTER TABLE `biens`
  MODIFY `id_bien` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT pour la table `bilans_patrimoniaux`
--
ALTER TABLE `bilans_patrimoniaux`
  MODIFY `id_bilan` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `coaching_budget_personnalise`
--
ALTER TABLE `coaching_budget_personnalise`
  MODIFY `id_coaching` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `comptes`
--
ALTER TABLE `comptes`
  MODIFY `id_compte` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=37;

--
-- AUTO_INCREMENT pour la table `conseils`
--
ALTER TABLE `conseils`
  MODIFY `id_conseil` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=191;

--
-- AUTO_INCREMENT pour la table `conseils_epargne`
--
ALTER TABLE `conseils_epargne`
  MODIFY `id_conseil_ct` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `depenses`
--
ALTER TABLE `depenses`
  MODIFY `id_depense` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=48;

--
-- AUTO_INCREMENT pour la table `depenses_biens`
--
ALTER TABLE `depenses_biens`
  MODIFY `id_depenses_biens` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT pour la table `dettes`
--
ALTER TABLE `dettes`
  MODIFY `id_dette` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT pour la table `epargner`
--
ALTER TABLE `epargner`
  MODIFY `id_epargner` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT pour la table `epargne_ct`
--
ALTER TABLE `epargne_ct`
  MODIFY `id_epargne_ct` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;

--
-- AUTO_INCREMENT pour la table `financer`
--
ALTER TABLE `financer`
  MODIFY `id_financer` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=51;

--
-- AUTO_INCREMENT pour la table `gains`
--
ALTER TABLE `gains`
  MODIFY `id_gain` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT pour la table `journal_financements`
--
ALTER TABLE `journal_financements`
  MODIFY `id_journal` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `paliers_pedagogiques_budget`
--
ALTER TABLE `paliers_pedagogiques_budget`
  MODIFY `id_palier` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `parcours_progression_utilisateur`
--
ALTER TABLE `parcours_progression_utilisateur`
  MODIFY `id_progression` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `pertes`
--
ALTER TABLE `pertes`
  MODIFY `id_engendrer_pertes` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT pour la table `profil_comportement_utilisateur`
--
ALTER TABLE `profil_comportement_utilisateur`
  MODIFY `id_profil` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT pour la table `recommandations_score_budget`
--
ALTER TABLE `recommandations_score_budget`
  MODIFY `id_reco` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `revenus`
--
ALTER TABLE `revenus`
  MODIFY `id_revenu` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT pour la table `revenus_biens`
--
ALTER TABLE `revenus_biens`
  MODIFY `id_revenus_biens` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT pour la table `score_budget_patrimonial`
--
ALTER TABLE `score_budget_patrimonial`
  MODIFY `id_score` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `score_stabilite_comptes`
--
ALTER TABLE `score_stabilite_comptes`
  MODIFY `id_score` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `sessions`
--
ALTER TABLE `sessions`
  MODIFY `id_session` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=78;

--
-- AUTO_INCREMENT pour la table `simulation_remboursement`
--
ALTER TABLE `simulation_remboursement`
  MODIFY `id_simulation` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `suggestions_affectation_revenus`
--
ALTER TABLE `suggestions_affectation_revenus`
  MODIFY `id_suggestion` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT pour la table `utilisateurs`
--
ALTER TABLE `utilisateurs`
  MODIFY `id_utilisateur` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=30;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_analysemensuelledettes`
--
DROP TABLE IF EXISTS `vue_analysemensuelledettes`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_analysemensuelledettes`  AS SELECT `d`.`id_dette` AS `id_dette`, `u`.`nom` AS `contracteur`, `d`.`montant_emprunt` AS `montant_emprunt`, `d`.`montant_remboursement` AS `montant_remboursement`, round(`d`.`montant_remboursement` / `d`.`montant_emprunt` * 100,2) AS `progression_remboursement`, `d`.`taux_d_interest` AS `taux_d_interest`, round((`d`.`montant_emprunt` - `d`.`montant_remboursement`) * `d`.`taux_d_interest` / 100,2) AS `interet_restant`, `d`.`date_emprunt` AS `date_emprunt`, `d`.`date_remboursement` AS `date_remboursement`, `d`.`statut` AS `statut` FROM (`dettes` `d` join `utilisateurs` `u` on(`u`.`id_utilisateur` = `d`.`id_contracteur`)) WHERE `d`.`statut` = 'active' ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_bilancomptesmensuel`
--
DROP TABLE IF EXISTS `vue_bilancomptesmensuel`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_bilancomptesmensuel`  AS SELECT `c`.`id_utilisateur` AS `id_utilisateur`, `u`.`nom` AS `utilisateur`, `c`.`type_compte` AS `type_compte`, sum(`c`.`solde`) AS `solde_total`, count(0) AS `nombre_comptes` FROM (`comptes` `c` join `utilisateurs` `u` on(`c`.`id_utilisateur` = `u`.`id_utilisateur`)) WHERE `c`.`statut` = 'actif' GROUP BY `c`.`id_utilisateur`, `c`.`type_compte` ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_classement_budget_mensuel`
--
DROP TABLE IF EXISTS `vue_classement_budget_mensuel`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_classement_budget_mensuel`  AS SELECT concat('Utilisateur_',`score_budget_patrimonial`.`id_utilisateur`) AS `pseudonyme`, `score_budget_patrimonial`.`score_global` AS `score_global`, `score_budget_patrimonial`.`badge_attribue` AS `badge_attribue`, `score_budget_patrimonial`.`mois` AS `mois`, `score_budget_patrimonial`.`annee` AS `annee` FROM `score_budget_patrimonial` WHERE `score_budget_patrimonial`.`mois` = month(curdate()) AND `score_budget_patrimonial`.`annee` = year(curdate()) ORDER BY `score_budget_patrimonial`.`score_global` DESC ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_comparaison_mensuelle`
--
DROP TABLE IF EXISTS `vue_comparaison_mensuelle`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_comparaison_mensuelle`  AS SELECT `b`.`id_bien` AS `id_bien`, `b`.`type_bien` AS `type_bien`, `bm1`.`date_bilan` AS `mois_precedent`, `bm1`.`montant_produit` AS `produit_mois_precedent`, `bm2`.`date_bilan` AS `mois_courant`, `bm2`.`montant_produit` AS `produit_mois_courant`, round(`bm2`.`montant_produit` - `bm1`.`montant_produit`,2) AS `variation` FROM ((`bilans_patrimoniaux` `bm1` join `bilans_patrimoniaux` `bm2` on(`bm1`.`id_bien` = `bm2`.`id_bien`)) join `biens` `b` on(`b`.`id_bien` = `bm1`.`id_bien`)) WHERE month(`bm1`.`date_bilan`) = month(curdate() - interval 1 month) AND month(`bm2`.`date_bilan`) = month(curdate()) AND year(`bm1`.`date_bilan`) = year(curdate()) AND year(`bm2`.`date_bilan`) = year(curdate()) ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_conseils_strategiques`
--
DROP TABLE IF EXISTS `vue_conseils_strategiques`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_conseils_strategiques`  AS SELECT `c`.`id_utilisateur` AS `id_utilisateur`, `c`.`type_conseil` AS `type_conseil`, `c`.`message_conseil` AS `message_conseil`, `c`.`date_generation` AS `date_generation` FROM `conseils` AS `c` WHERE `c`.`type_conseil` in ('strategique','discipline','coaching') ORDER BY `c`.`date_generation` DESC LIMIT 0, 5 ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_profile_strategique`
--
DROP TABLE IF EXISTS `vue_profile_strategique`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_profile_strategique`  AS SELECT `u`.`id_utilisateur` AS `id_utilisateur`, `u`.`nom` AS `nom`, `u`.`score_fidelite` AS `score_fidelite`, `sb`.`score_global` AS `score_global`, `pp`.`palier_atteint` AS `palier_atteint`, `c`.`message_conseil` AS `message_conseil`, `cb`.`message_conseil` AS `suggestion_active` FROM ((((`utilisateurs` `u` left join `score_budget_patrimonial` `sb` on(`sb`.`id_utilisateur` = `u`.`id_utilisateur`)) left join `parcours_progression_utilisateur` `pp` on(`pp`.`id_utilisateur` = `u`.`id_utilisateur`)) left join `conseils` `c` on(`c`.`id_utilisateur` = `u`.`id_utilisateur`)) left join `coaching_budget_personnalise` `cb` on(`cb`.`id_utilisateur` = `u`.`id_utilisateur` and `cb`.`statut` = 'proposé')) ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_progression_epargne`
--
DROP TABLE IF EXISTS `vue_progression_epargne`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_progression_epargne`  AS SELECT `epargne_ct`.`id_epargne_ct` AS `id_epargne_ct`, `epargne_ct`.`objectif` AS `objectif`, round(`epargne_ct`.`montant_actuel` / `epargne_ct`.`montant_vise` * 100,2) AS `progression_effective` FROM `epargne_ct` ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_stats_sessions_mensuelles`
--
DROP TABLE IF EXISTS `vue_stats_sessions_mensuelles`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_stats_sessions_mensuelles`  AS SELECT `sessions`.`id_utilisateur` AS `id_utilisateur`, count(0) AS `nb_sessions`, avg(time_to_sec(`sessions`.`duree_session`) / 60) AS `durée_moyenne_minutes`, max(`sessions`.`date_connexion`) AS `derniere_connexion` FROM `sessions` WHERE month(`sessions`.`date_connexion`) = month(curdate()) AND year(`sessions`.`date_connexion`) = year(curdate()) GROUP BY `sessions`.`id_utilisateur` ;

-- --------------------------------------------------------

--
-- Structure de la vue `vue_taux_rendementmensuel`
--
DROP TABLE IF EXISTS `vue_taux_rendementmensuel`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vue_taux_rendementmensuel`  AS SELECT `b`.`id_bien` AS `id_bien`, `b`.`type_bien` AS `type_bien`, `b`.`montant_acquisition` AS `montant_acquisition`, coalesce(sum(`g`.`montant_gain`),0) AS `gain_mensuel`, round(coalesce(sum(`g`.`montant_gain`),0) / `b`.`montant_acquisition` * 100,2) AS `taux_rendement` FROM (`biens` `b` left join `gains` `g` on(`b`.`id_bien` = `g`.`id_bien`)) WHERE month(`g`.`date_gain`) = month(curdate()) AND year(`g`.`date_gain`) = year(curdate()) GROUP BY `b`.`id_bien` ;

--
-- Contraintes pour les tables déchargées
--

--
-- Contraintes pour la table `actions_patrimoniales_recommandees`
--
ALTER TABLE `actions_patrimoniales_recommandees`
  ADD CONSTRAINT `Actions_Patrimoniales_Recommandees_ibfk_1` FOREIGN KEY (`id_epargne_ct`) REFERENCES `epargne_ct` (`id_epargne_ct`);

--
-- Contraintes pour la table `alertes_comptes`
--
ALTER TABLE `alertes_comptes`
  ADD CONSTRAINT `Alertes_Comptes_ibfk_1` FOREIGN KEY (`id_compte`) REFERENCES `comptes` (`id_compte`);

--
-- Contraintes pour la table `alertes_depenses`
--
ALTER TABLE `alertes_depenses`
  ADD CONSTRAINT `Alertes_Depenses_ibfk_1` FOREIGN KEY (`id_faiseur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `alertes_dettes`
--
ALTER TABLE `alertes_dettes`
  ADD CONSTRAINT `Alertes_Dettes_ibfk_1` FOREIGN KEY (`id_dette`) REFERENCES `dettes` (`id_dette`);

--
-- Contraintes pour la table `alertes_epargne_ct`
--
ALTER TABLE `alertes_epargne_ct`
  ADD CONSTRAINT `Alertes_Epargne_CT_ibfk_1` FOREIGN KEY (`id_epargne_ct`) REFERENCES `epargne_ct` (`id_epargne_ct`);

--
-- Contraintes pour la table `alertes_patrimoniales`
--
ALTER TABLE `alertes_patrimoniales`
  ADD CONSTRAINT `Alertes_Patrimoniales_ibfk_1` FOREIGN KEY (`id_bien`) REFERENCES `biens` (`id_bien`);

--
-- Contraintes pour la table `alertes_revenus`
--
ALTER TABLE `alertes_revenus`
  ADD CONSTRAINT `Alertes_Revenus_ibfk_1` FOREIGN KEY (`id_revenu`) REFERENCES `revenus` (`id_revenu`);

--
-- Contraintes pour la table `biens`
--
ALTER TABLE `biens`
  ADD CONSTRAINT `Biens_ibfk_1` FOREIGN KEY (`id_epargne_ct`) REFERENCES `epargne_ct` (`id_epargne_ct`),
  ADD CONSTRAINT `Biens_ibfk_2` FOREIGN KEY (`id_dette`) REFERENCES `dettes` (`id_dette`);

--
-- Contraintes pour la table `bilans_patrimoniaux`
--
ALTER TABLE `bilans_patrimoniaux`
  ADD CONSTRAINT `Bilans_Patrimoniaux_ibfk_1` FOREIGN KEY (`id_bien`) REFERENCES `biens` (`id_bien`);

--
-- Contraintes pour la table `coaching_budget_personnalise`
--
ALTER TABLE `coaching_budget_personnalise`
  ADD CONSTRAINT `Coaching_Budget_Personnalise_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `comptes`
--
ALTER TABLE `comptes`
  ADD CONSTRAINT `Comptes_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `conseils`
--
ALTER TABLE `conseils`
  ADD CONSTRAINT `Conseils_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `depenses`
--
ALTER TABLE `depenses`
  ADD CONSTRAINT `Depenses_ibfk_1` FOREIGN KEY (`id_faiseur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Depenses_ibfk_2` FOREIGN KEY (`id_receveur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `depenses_biens`
--
ALTER TABLE `depenses_biens`
  ADD CONSTRAINT `Depenses_Biens_ibfk_1` FOREIGN KEY (`id_bien`) REFERENCES `biens` (`id_bien`);

--
-- Contraintes pour la table `dettes`
--
ALTER TABLE `dettes`
  ADD CONSTRAINT `Dettes_ibfk_1` FOREIGN KEY (`id_contracteur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Dettes_ibfk_2` FOREIGN KEY (`id_octroyeur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Dettes_ibfk_3` FOREIGN KEY (`id_compte`) REFERENCES `comptes` (`id_compte`);

--
-- Contraintes pour la table `epargner`
--
ALTER TABLE `epargner`
  ADD CONSTRAINT `Epargner_ibfk3` FOREIGN KEY (`id_epargne_ct`) REFERENCES `epargne_ct` (`id_epargne_ct`),
  ADD CONSTRAINT `Epargner_ibfk_1` FOREIGN KEY (`id_revenu`) REFERENCES `revenus` (`id_revenu`),
  ADD CONSTRAINT `Epargner_ibfk_2` FOREIGN KEY (`id_gain`) REFERENCES `gains` (`id_gain`);

--
-- Contraintes pour la table `epargne_ct`
--
ALTER TABLE `epargne_ct`
  ADD CONSTRAINT `Epargne_CT_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Epargne_CT_ibfk_2` FOREIGN KEY (`id_compte`) REFERENCES `comptes` (`id_compte`);

--
-- Contraintes pour la table `financer`
--
ALTER TABLE `financer`
  ADD CONSTRAINT `Financer_ibfk3` FOREIGN KEY (`id_gain`) REFERENCES `gains` (`id_gain`),
  ADD CONSTRAINT `Financer_ibfk_1` FOREIGN KEY (`id_revenu`) REFERENCES `revenus` (`id_revenu`),
  ADD CONSTRAINT `Financer_ibfk_2` FOREIGN KEY (`id_depense`) REFERENCES `depenses` (`id_depense`);

--
-- Contraintes pour la table `gains`
--
ALTER TABLE `gains`
  ADD CONSTRAINT `Gains_ibfk_1` FOREIGN KEY (`id_bien`) REFERENCES `biens` (`id_bien`);

--
-- Contraintes pour la table `journal_financements`
--
ALTER TABLE `journal_financements`
  ADD CONSTRAINT `Journal_Financements_ibfk_1` FOREIGN KEY (`id_financer`) REFERENCES `financer` (`id_financer`);

--
-- Contraintes pour la table `parcours_progression_utilisateur`
--
ALTER TABLE `parcours_progression_utilisateur`
  ADD CONSTRAINT `Parcours_Progression_Utilisateur_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `pertes`
--
ALTER TABLE `pertes`
  ADD CONSTRAINT `Pertes_ibfk_1` FOREIGN KEY (`id_bien`) REFERENCES `biens` (`id_bien`);

--
-- Contraintes pour la table `profil_comportement_utilisateur`
--
ALTER TABLE `profil_comportement_utilisateur`
  ADD CONSTRAINT `Profil_Comportement_Utilisateur_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `revenus`
--
ALTER TABLE `revenus`
  ADD CONSTRAINT `Revenus_ibfk_1` FOREIGN KEY (`id_receveur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Revenus_ibfk_2` FOREIGN KEY (`id_donneur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Revenus_ibfk_3` FOREIGN KEY (`id_compte`) REFERENCES `comptes` (`id_compte`);

--
-- Contraintes pour la table `revenus_biens`
--
ALTER TABLE `revenus_biens`
  ADD CONSTRAINT `Revenus_Biens_ibfk_1` FOREIGN KEY (`id_bien`) REFERENCES `biens` (`id_bien`);

--
-- Contraintes pour la table `score_budget_patrimonial`
--
ALTER TABLE `score_budget_patrimonial`
  ADD CONSTRAINT `Score_Budget_Patrimonial_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `score_stabilite_comptes`
--
ALTER TABLE `score_stabilite_comptes`
  ADD CONSTRAINT `Score_Stabilite_Comptes_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`),
  ADD CONSTRAINT `Score_Stabilite_Comptes_ibfk_2` FOREIGN KEY (`id_compte`) REFERENCES `comptes` (`id_compte`);

--
-- Contraintes pour la table `sessions`
--
ALTER TABLE `sessions`
  ADD CONSTRAINT `Sessions_ibfk_1` FOREIGN KEY (`id_utilisateur`) REFERENCES `utilisateurs` (`id_utilisateur`);

--
-- Contraintes pour la table `simulation_remboursement`
--
ALTER TABLE `simulation_remboursement`
  ADD CONSTRAINT `Simulation_Remboursement_ibfk_1` FOREIGN KEY (`id_dette`) REFERENCES `dettes` (`id_dette`);

--
-- Contraintes pour la table `suggestions_affectation_revenus`
--
ALTER TABLE `suggestions_affectation_revenus`
  ADD CONSTRAINT `Suggestions_Affectation_Revenus_ibfk_1` FOREIGN KEY (`id_revenu`) REFERENCES `revenus` (`id_revenu`);

DELIMITER $$
--
-- Évènements
--
CREATE DEFINER=`root`@`localhost` EVENT `VerifierConseilsEpargne` ON SCHEDULE EVERY 1 DAY STARTS '2025-07-20 10:17:15' ON COMPLETION NOT PRESERVE ENABLE DO CALL RecommanderConseilEpargne()$$

CREATE DEFINER=`root`@`localhost` EVENT `event_rentabilite_biens` ON SCHEDULE EVERY 1 MONTH STARTS '2025-01-05 00:00:00' ENDS '2025-12-05 00:00:00' ON COMPLETION NOT PRESERVE ENABLE DO CALL ActualiserRentabiliteBiensMensuelle()$$

CREATE DEFINER=`root`@`localhost` EVENT `ProposerActionsEpargne` ON SCHEDULE EVERY 1 DAY STARTS '2025-07-20 10:18:49' ON COMPLETION NOT PRESERVE ENABLE DO CALL DéduireActionsEpargne()$$

CREATE DEFINER=`root`@`localhost` EVENT `VerifierContrePerformance` ON SCHEDULE EVERY 1 MONTH STARTS '2025-07-21 00:00:00' ON COMPLETION NOT PRESERVE ENABLE DO BEGIN
    -- Analyse des biens avec performance négative deux mois consécutifs
    INSERT INTO Alertes_Patrimoniales (
        id_bien, date_alerte, type_alerte, niveau_gravite, description
    )
    SELECT 
        BP1.id_bien,
        CURDATE(),
        'Contre-performance recurrente',
        'eleve',
        CONCAT('Deux mois consécutifs de perte. Rendement ', BP1.rendement_mensuel, '% le mois dernier et ', BP2.rendement_mensuel, '% ce mois.')
    FROM Bilans_Patrimoniaux BP1
    JOIN Bilans_Patrimoniaux BP2 
        ON BP1.id_bien = BP2.id_bien 
        AND MONTH(BP1.date_bilan) = MONTH(CURDATE() - INTERVAL 1 MONTH)
        AND MONTH(BP2.date_bilan) = MONTH(CURDATE())
        AND YEAR(BP1.date_bilan) = YEAR(CURDATE())
        AND YEAR(BP2.date_bilan) = YEAR(CURDATE())
    WHERE BP1.montant_produit < 0 AND BP2.montant_produit < 0;
END$$

CREATE DEFINER=`root`@`localhost` EVENT `EnregistrerBilanMensuel` ON SCHEDULE EVERY 1 MONTH STARTS '2025-07-21 00:00:00' ON COMPLETION NOT PRESERVE ENABLE DO BEGIN
    INSERT INTO Bilans_Patrimoniaux (
        id_bien, date_bilan, montant_produit, total_gains, total_pertes, rendement_mensuel, commentaire
    )
    SELECT
        B.id_bien,
        CURDATE(),
        B.montant_produit,
        COALESCE(SUM(G.montant), 0),
        COALESCE(SUM(P.montant_perte), 0),
        ROUND(COALESCE(SUM(G.montant), 0) / B.montant_acquisition * 100, 2),
        IF(B.montant_produit < 0, 'Attention : perte enregistrée ce mois.', 'Rendement positif.')
    FROM Biens B
    LEFT JOIN Gains G ON B.id_bien = G.id_bien AND MONTH(G.date_gain) = MONTH(CURDATE()) AND YEAR(G.date_gain) = YEAR(CURDATE())
    LEFT JOIN Pertes P ON B.id_bien = P.id_bien AND MONTH(P.date_perte) = MONTH(CURDATE()) AND YEAR(P.date_perte) = YEAR(CURDATE())
    GROUP BY B.id_bien;
END$$

DELIMITER ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
